package com.elitesland.cloudt.context.threadpool.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.config.ThreadPoolProperties;
import com.dtp.core.DtpRegistry;
import com.dtp.core.thread.DtpExecutor;
import com.elitesland.cloudt.context.threadpool.ThreadPoolHolder;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;

/**
 * 自定义TaskExecutor.
 *
 * @author Kaiser（wang shao）
 * @date 2022/2/20
 */
public class CustomTaskExecutor implements TaskExecutor {

    public static final String CLOUDT_DTP_DEFAULT = "cloudT-dtp-default";
    public static final String CLOUDT_TP = "cloudT-tp-";

    private DtpExecutor dtpExecutor;

    public CustomTaskExecutor(DtpProperties dtpProperties) {
        buildDtpExecutor(dtpProperties);
    }

    @Override
    public void execute(@NonNull Runnable task) {
        if (dtpExecutor == null) {
            dtpExecutor = DtpRegistry.getDtpExecutor(CLOUDT_DTP_DEFAULT);
        }
        dtpExecutor.execute(task);
    }

    private void buildDtpExecutor(DtpProperties dtpProperties) {
        var executorsConfigs = dtpProperties.getExecutors();
        if (dtpProperties.isEnabled() && !CollectionUtils.isEmpty(executorsConfigs)) {
            for (ThreadPoolProperties executorsConfig : executorsConfigs) {
                if (CharSequenceUtil.equals(executorsConfig.getThreadPoolName(), CLOUDT_DTP_DEFAULT)) {
                    // 已存在相关配置，则DtpRegistry.afterPropertiesSet()会自动创建，无需手动创建
                    return;
                }
            }
        }

        // 构建默认的dtpExecutor
        ThreadPoolHolder.createThreadPool(CLOUDT_DTP_DEFAULT, CLOUDT_TP, 8, 17);
    }
}
