/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.dubbo;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.elitesland.cloudt.context.SpringContextHolder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.apache.dubbo.config.bootstrap.builders.ReferenceBuilder;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.nacos.NacosNamingServiceWrapper;
import org.apache.dubbo.registry.nacos.NacosRegistry;
import org.apache.dubbo.registry.nacos.util.NacosNamingServiceUtils;
import org.apache.dubbo.registry.support.RegistryManager;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DubboNacosHolder {
    private static final Logger log = LogManager.getLogger(DubboNacosHolder.class);

    public static List<RegistryConfig> getRegistryConfig() {
        return DubboBootstrap.getInstance().getConfigManager().getRegistries().stream().toList();
    }

    public static List<Registry> getRegistries() {
        return RegistryManager.getInstance((ApplicationModel)DubboBootstrap.getInstance().getApplicationModel()).getRegistries().stream().toList();
    }

    public static NacosRegistry getRegistryOfNacos() {
        List<Registry> registries = DubboNacosHolder.getRegistries();
        if (registries.isEmpty()) {
            return null;
        }
        for (Registry registry : registries) {
            if (!(registry instanceof NacosRegistry)) continue;
            return (NacosRegistry)registry;
        }
        return null;
    }

    public static NacosNamingServiceWrapper getNacosNamingServiceWrapper() {
        NacosRegistry registry = DubboNacosHolder.getRegistryOfNacos();
        if (registry == null) {
            log.warn("\u672a\u83b7\u53d6\u5230NacosRegistry");
            return null;
        }
        URL registryUrl = registry.getUrl();
        return NacosNamingServiceUtils.createNamingService((URL)registryUrl);
    }

    public static String buildServiceName(String category, Class<?> serviceInterface, String version) {
        return (String)Assert.notBlank((CharSequence)category) + ":" + serviceInterface.getName() + ":" + CharSequenceUtil.blankToDefault((CharSequence)version, (String)"") + ":";
    }

    public static List<Instance> queryNacosInstance(String serviceName, String group) throws NacosException {
        NacosNamingServiceWrapper nacosNamingServiceWrapper;
        if (CharSequenceUtil.isBlank((CharSequence)group)) {
            group = SpringContextHolder.getProperty("dubbo.registry.group", "DEFAULT_GROUP");
        }
        if ((nacosNamingServiceWrapper = DubboNacosHolder.getNacosNamingServiceWrapper()) == null) {
            log.warn("\u672a\u83b7\u53d6\u5230NacosNamingServiceWrapper");
            return Collections.emptyList();
        }
        return nacosNamingServiceWrapper.getAllInstances(serviceName, group);
    }

    public static Map<String, List<Instance>> queryNacosInstanceForApplication(String serviceName, String group) throws NacosException {
        List<Instance> instances = DubboNacosHolder.queryNacosInstance(serviceName, group);
        if (instances.isEmpty()) {
            return Collections.emptyMap();
        }
        return instances.stream().collect(Collectors.groupingBy(t -> t.getMetadata().getOrDefault("application", "unknown")));
    }

    public static <T> T getInstanceOfSpecial(Class<T> serviceInterface, String version, Instance instance) {
        return (T)((ReferenceBuilder)ReferenceBuilder.newBuilder().interfaceClass(serviceInterface).version(version)).url("dubbo://" + instance.getIp() + ":" + instance.getPort()).build().get();
    }
}

