/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.threadpool.support;

import com.elitesland.cloudt.context.SpringContextHolder;
import com.elitesland.cloudt.context.threadpool.support.ContextTransfer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.util.CollectionUtils;

public class ContextTransferDelegate {
    private static final Logger log = LogManager.getLogger(ContextTransferDelegate.class);
    private static final List<ContextTransfer> CONTEXT_TRANSFER_FACTORY = new ArrayList<ContextTransfer>();
    private final List<ContextTransfer> contextTransfers;
    private final Map<ContextTransfer, Object> contextMap = new HashMap<ContextTransfer, Object>();

    private ContextTransferDelegate(List<ContextTransfer> contextTransfers) {
        this.contextTransfers = contextTransfers;
    }

    private static void setContextTransferFactory(List<ContextTransfer> contextTransfersNew) {
        CONTEXT_TRANSFER_FACTORY.clear();
        if (contextTransfersNew == null || contextTransfersNew.isEmpty()) {
            return;
        }
        CONTEXT_TRANSFER_FACTORY.addAll(contextTransfersNew);
    }

    public static ContextTransferDelegate getInstance() {
        if (CONTEXT_TRANSFER_FACTORY.isEmpty()) {
            ContextTransferDelegate.loadContextTransferFactory();
        }
        return new ContextTransferDelegate(CONTEXT_TRANSFER_FACTORY);
    }

    public void getContext() {
        if (CollectionUtils.isEmpty(this.contextTransfers)) {
            return;
        }
        for (ContextTransfer contextTransfer : this.contextTransfers) {
            Object value = null;
            try {
                value = contextTransfer.getContext();
            }
            catch (Exception e) {
                log.error("\u4e0a\u4e0b\u6587\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38\uff1a", (Throwable)e);
                continue;
            }
            if (value == null) continue;
            this.contextMap.put(contextTransfer, value);
        }
    }

    public void setContext() {
        if (this.contextMap.isEmpty()) {
            return;
        }
        for (Map.Entry<ContextTransfer, Object> entry : this.contextMap.entrySet()) {
            try {
                entry.getKey().setContext(entry.getValue());
            }
            catch (Exception e) {
                log.error("\u4e0a\u4e0b\u6587\u4fe1\u606f\u8bbe\u7f6e\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }

    public void clearContext() {
        if (this.contextMap.isEmpty()) {
            return;
        }
        for (Map.Entry<ContextTransfer, Object> entry : this.contextMap.entrySet()) {
            try {
                entry.getKey().clearContext();
            }
            catch (Exception e) {
                log.error("\u4e0a\u4e0b\u6587\u4fe1\u606f\u6e05\u9664\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }

    private static void loadContextTransferFactory() {
        ObjectProvider<ContextTransfer> transferProvider = SpringContextHolder.getObjectProvider(ContextTransfer.class);
        List<ContextTransfer> transfers = transferProvider.stream().collect(Collectors.toList());
        ContextTransferDelegate.setContextTransferFactory(transfers);
    }
}

