/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.redis.redisson;

import cn.hutool.core.util.StrUtil;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.redisson.config.TransportMode;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.redisson.spring.starter.RedissonAutoConfiguration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;

@Configuration
@AutoConfigureBefore(value={RedisAutoConfiguration.class, RedissonAutoConfiguration.class})
@ConditionalOnClass(value={Redisson.class, RedisOperations.class})
@ConditionalOnProperty(prefix="elitesland.redis.redisson", name={"enabled"}, havingValue="false", matchIfMissing=true)
@Deprecated(since="2.0", forRemoval=true)
public class RedissonConfig {
    private static final Logger log = LogManager.getLogger(RedissonConfig.class);
    @Value(value="${redis.redisson-cluster-config.nodes:#{null}}")
    private String nodes;
    @Value(value="${redis.redisson-cluster-config.password:#{null}}")
    private String password;
    @Value(value="${redis.redlock-instance-config.database:#{0}}")
    private int database;
    @Value(value="${redis.redlock-instance-config.node0.host:#{null}}")
    private String node0Host;
    @Value(value="${redis.redlock-instance-config.node0.password:#{null}}")
    private String node0Password;
    @Value(value="${redis.redlock-instance-config.node1.host:#{null}}")
    private String node1Host;
    @Value(value="${redis.redlock-instance-config.node1.password:#{null}}")
    private String node1Password;
    @Value(value="${redis.redlock-instance-config.node2.host:#{null}}")
    private String node2Host;
    @Value(value="${redis.redlock-instance-config.node2.password:#{null}}")
    private String node2Password;

    public RedissonConfig() {
        log.info("\u521d\u59cb\u5316\u65e7\u7684redisson\u914d\u7f6e\uff01");
    }

    @Primary
    @Bean(value={"cluster_redis_client"})
    @ConditionalOnProperty(prefix="redis.redisson-cluster-config", name={"enabled"}, havingValue="true")
    public RedissonClient initRedissonClient() {
        if (StrUtil.isBlank((CharSequence)this.nodes)) {
            log.warn("\u52a0\u8f7dredission\u914d\u7f6e\u5931\u8d25");
            return Redisson.create();
        }
        Config config = new Config();
        config.setTransportMode(TransportMode.NIO);
        ((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().addNodeAddress((String[])Arrays.stream(this.nodes.split(",")).map(String::strip).toArray(String[]::new)).setPassword(this.password)).setScanInterval(3000).setSubscriptionConnectionPoolSize(25)).setSlaveConnectionMinimumIdleSize(16)).setSlaveConnectionPoolSize(32)).setMasterConnectionMinimumIdleSize(16)).setMasterConnectionPoolSize(32)).setConnectTimeout(20000)).setTimeout(5000)).setRetryInterval(3000);
        return Redisson.create((Config)config);
    }

    @Bean(value={"redis_single_client0"})
    @ConditionalOnProperty(prefix="redis.redlock-instance-config", name={"enabled"}, havingValue="true")
    public RedissonClient initRedissonClientSingle0() {
        if (StrUtil.isBlank((CharSequence)this.node0Host)) {
            log.warn("\u52a0\u8f7dredission\u914d\u7f6enode0\u5931\u8d25");
            return Redisson.create();
        }
        Config config = new Config();
        ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(this.node0Host).setPassword(this.node0Password)).setSubscriptionConnectionPoolSize(25).setConnectionMinimumIdleSize(16).setConnectionPoolSize(32).setConnectTimeout(20000)).setTimeout(5000)).setRetryInterval(3000)).setDatabase(this.database);
        return Redisson.create((Config)config);
    }

    @Bean(value={"redis_single_client1"})
    @ConditionalOnProperty(prefix="redis.redlock-instance-config", name={"enabled"}, havingValue="true")
    public RedissonClient initRedissonClientSingle1() {
        if (StrUtil.isBlank((CharSequence)this.node1Host)) {
            log.warn("\u52a0\u8f7dredission\u914d\u7f6enode1\u5931\u8d25");
            return Redisson.create();
        }
        Config config = new Config();
        ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(this.node1Host).setPassword(this.node1Password)).setSubscriptionConnectionPoolSize(25).setConnectionMinimumIdleSize(16).setConnectionPoolSize(32).setConnectTimeout(20000)).setTimeout(5000)).setRetryInterval(3000)).setDatabase(this.database);
        return Redisson.create((Config)config);
    }

    @Bean(value={"redis_single_client2"})
    @ConditionalOnProperty(prefix="redis.redlock-instance-config", name={"enabled"}, havingValue="true")
    public RedissonClient initRedissonClientSingle2() {
        if (StrUtil.isBlank((CharSequence)this.node1Host)) {
            log.warn("\u52a0\u8f7dredission\u914d\u7f6enode2\u5931\u8d25");
            return Redisson.create();
        }
        Config config = new Config();
        ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(this.node2Host).setPassword(this.node2Password)).setSubscriptionConnectionPoolSize(25).setConnectionMinimumIdleSize(16).setConnectionPoolSize(32).setConnectTimeout(20000)).setTimeout(5000)).setRetryInterval(3000)).setDatabase(this.database);
        return Redisson.create((Config)config);
    }

    @Bean
    @ConditionalOnProperty(prefix="redis.redisson-cluster-config", name={"enabled"}, havingValue="true")
    public RedisConnectionFactory initRedissonConnectionFactory(@Qualifier(value="cluster_redis_client") RedissonClient redissonClient) {
        return new RedissonConnectionFactory(redissonClient);
    }
}

