/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.redis;

import com.elitesland.cloudt.context.redis.CloudtRedisProperties;
import com.elitesland.cloudt.context.redis.RedisKeyPrefix;
import com.elitesland.cloudt.context.redis.RedisWrapper;
import com.elitesland.yst.common.config.CacheKeyGenerator;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CloudtRedisProperties.class})
@ConditionalOnClass(value={RedisTemplate.class})
public class CloudtRedisAutoConfiguration {
    private static final Logger log = LogManager.getLogger(CloudtRedisAutoConfiguration.class);
    private final CloudtRedisProperties cloudtRedisProperties;

    public CloudtRedisAutoConfiguration(CloudtRedisProperties cloudtRedisProperties) {
        this.cloudtRedisProperties = cloudtRedisProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisWrapper.class})
    public RedisWrapper redisWrapper() {
        log.info("\u521d\u59cb\u5316\u9ed8\u8ba4redisWrapper");
        return (callable, param) -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                log.error("redis\u8c03\u7528\u5931\u8d25", (Throwable)e);
                throw new RuntimeException("\u6267\u884credis\u8c03\u7528\u5931\u8d25", e);
            }
        };
    }

    @Bean
    public CacheKeyGenerator redisCacheKeyGenerator(ObjectProvider<RedisKeyPrefix> redisKeyPrefixObjectProvider) {
        RedisKeyPrefix redisKeyPrefix = (RedisKeyPrefix)redisKeyPrefixObjectProvider.getIfAvailable();
        return key -> {
            Object pre = "";
            if (StringUtils.hasText((String)this.cloudtRedisProperties.getPrefix())) {
                pre = this.cloudtRedisProperties.getPrefix() + ":";
            }
            if (redisKeyPrefix != null) {
                pre = (String)pre + redisKeyPrefix.getKeyPrefix() + ":";
            }
            if (key.indexOf((String)pre) == 0) {
                return key;
            }
            return (String)pre + key;
        };
    }

    @Bean
    public RedisTemplate redisTemplate(RedisConnectionFactory redisConnectionFactory, CacheKeyGenerator cacheKeyGenerator) {
        RedisTemplate template = new RedisTemplate();
        RedisSerializer<String> redisSerializer = this.redisSerializer(cacheKeyGenerator);
        template.setConnectionFactory(redisConnectionFactory);
        template.setKeySerializer(redisSerializer);
        template.setHashKeySerializer(redisSerializer);
        template.setValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        template.setHashValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        return template;
    }

    @Bean
    @Primary
    public CacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory, CacheKeyGenerator cacheKeyGenerator) {
        return new RedisCacheManager(RedisCacheWriter.lockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory), RedisCacheConfiguration.defaultCacheConfig().disableCachingNullValues().computePrefixWith(arg_0 -> ((CacheKeyGenerator)cacheKeyGenerator).computeKey(arg_0)));
    }

    private RedisSerializer<String> redisSerializer(final CacheKeyGenerator cacheKeyGenerator) {
        return new RedisSerializer<String>(){
            private final Charset charset = StandardCharsets.UTF_8;

            public String deserialize(byte[] bytes) {
                if (bytes == null) {
                    return null;
                }
                return new String(bytes, this.charset);
            }

            public byte[] serialize(String key) {
                if (key == null) {
                    return new byte[0];
                }
                key = cacheKeyGenerator.computeKey(key);
                return key.getBytes(this.charset);
            }
        };
    }
}

