/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.flyway;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.db.dialect.DriverUtil;
import com.elitesland.cloudt.context.flyway.FlywayCloudtProperties;
import com.elitesland.yst.common.exception.BusinessException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.flywaydb.core.Flyway;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

public class FlywayBuilder {
    private static final Logger log = LogManager.getLogger(FlywayBuilder.class);
    private final DataSource dataSource;
    private final FlywayCloudtProperties properties;

    public FlywayBuilder(DataSource dataSource, FlywayCloudtProperties properties) {
        this.dataSource = dataSource;
        this.properties = properties;
    }

    Flyway createFlywayForSys() {
        Assert.notEmpty(this.properties.getLocationSys(), (String)"\u672a\u77e5\u7cfb\u7edf\u9ed8\u8ba4\u6570\u636e\u5e93\u811a\u672c\u8def\u5f84", (Object[])new Object[0]);
        String[] locations = (String[])this.properties.getLocationSys().stream().map(this::buildLocation).toArray(String[]::new);
        log.info("\u9ed8\u8ba4SQL\u811a\u672c\u8def\u5f84\uff1a{}", new Supplier[]{() -> Arrays.toString(locations)});
        return Flyway.configure().dataSource(this.dataSource).locations(locations).schemas(new String[]{StringUtils.hasText((String)this.properties.getSchemaDefault()) ? this.properties.getSchemaDefault() : null}).baselineOnMigrate(this.properties.isBaselineOnMigrate()).baselineVersion(this.properties.getBaselineVersion()).validateOnMigrate(this.properties.isValidateOnMigrate()).validateMigrationNaming(this.properties.isValidateMigrationNaming()).outOfOrder(this.properties.isOutOfOrder()).load();
    }

    public Flyway createFlywayForTenant(String prefix, String schema) {
        Assert.notEmpty(this.properties.getLocationTenant(), (String)"\u672a\u77e5\u79df\u6237\u6570\u636e\u5e93\u811a\u672c\u8def\u5f84", (Object[])new Object[0]);
        String[] locations = (String[])this.properties.getLocationTenant().stream().map(this::buildLocation).toArray(String[]::new);
        log.info("\u79df\u6237SQL\u811a\u672c\u8def\u5f84\uff1a{}", new Supplier[]{() -> Arrays.toString(locations)});
        prefix = CharSequenceUtil.isBlank((CharSequence)prefix) ? "" : (String)prefix + "_";
        return Flyway.configure().dataSource(this.dataSource).locations(locations).schemas(new String[]{(String)prefix + schema}).validateOnMigrate(this.properties.isBaselineOnMigrate()).baselineVersion(this.properties.getBaselineVersion()).validateOnMigrate(this.properties.isValidateOnMigrate()).validateMigrationNaming(this.properties.isValidateMigrationNaming()).outOfOrder(this.properties.isOutOfOrder()).load();
    }

    private String buildLocation(String location) {
        String databaseProductName;
        Object tempLocation = "";
        if (StringUtils.hasText((String)this.properties.getProject()) && this.resourceExists((String)(tempLocation = (String)location + "/" + this.properties.getProject()))) {
            location = tempLocation;
        }
        if (this.resourceExists((String)(tempLocation = (String)location + "/" + (databaseProductName = this.getDatabaseProductName())))) {
            location = tempLocation;
        }
        return location;
    }

    private boolean resourceExists(String path) {
        String classpath = "classpath:";
        if (path.startsWith(classpath)) {
            path = path.substring(classpath.length());
        }
        try {
            ClassPathResource resource = new ClassPathResource(path);
            return resource.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getDatabaseProductName() {
        String productName = null;
        try (Connection connection = this.dataSource.getConnection();){
            productName = connection.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            log.error("\u83b7\u53d6\u6570\u636e\u5e93\u5382\u5546\u540d\u79f0\u5931\u8d25\uff1a", (Throwable)e);
        }
        if (StringUtils.hasText(productName)) {
            return productName.toLowerCase();
        }
        productName = ((String)ObjectUtil.defaultIfNull((Object)DriverUtil.identifyDriver((DataSource)this.dataSource), (Object)"")).toLowerCase();
        if (productName.contains("mysql")) {
            return "mysql";
        }
        if (productName.contains("oracle")) {
            return "oracle";
        }
        throw new BusinessException("\u672a\u77e5\u6570\u636e\u5e93\u5382\u5546");
    }
}

