/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;

public class DatetimeUtil {
    public static final DateTimeFormatter FORMATTER_DATETIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter FORMATTER_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter FORMATTER_TIME = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter FORMATTER_DATETIME_LONG = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    public static final ZoneOffset SYS_ZONE_OFFSET = ZoneOffset.of("+8");
    public static final TimeZone SYS_TIME_ZONE = TimeZone.getTimeZone(SYS_ZONE_OFFSET);

    public static String currentTimeStr() {
        return FORMATTER_DATETIME.format(LocalDateTime.now());
    }

    public static String currentTimeLong() {
        return FORMATTER_DATETIME_LONG.format(LocalDateTime.now());
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        return date.toInstant().atOffset(SYS_ZONE_OFFSET).toLocalDateTime();
    }

    public static Date localDateTime2Date(LocalDateTime dateTime) {
        return Date.from(dateTime.atZone(SYS_ZONE_OFFSET).toInstant());
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return instant.atZone(SYS_ZONE_OFFSET).toLocalDateTime();
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        return localDateTime.toInstant(SYS_ZONE_OFFSET);
    }
}

