/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.support;

import com.elitesland.cloudt.tenant.config.TenantClientProperties;
import com.elitesland.cloudt.tenant.config.support.TenantContextHolder;
import com.elitesland.cloudt.tenant.provider.TenantProvider;
import com.elitesland.yst.common.common.CloudtOptional;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.dto.SysTenantDTO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class TenantRequestInterceptor
implements AsyncHandlerInterceptor {
    private static final Logger log = LogManager.getLogger(TenantRequestInterceptor.class);
    private final TenantProvider tenantProvider;
    private final TenantClientProperties clientProperties;

    public TenantRequestInterceptor(TenantProvider tenantProvider, TenantClientProperties clientProperties) {
        this.tenantProvider = tenantProvider;
        this.clientProperties = clientProperties;
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        SysTenantDTO tenant = this.analyzeSysTenant(request);
        if (tenant != null) {
            TenantContextHolder.setCurrentTenant(tenant);
        }
        return true;
    }

    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        TenantContextHolder.clearCurrent();
    }

    private SysTenantDTO analyzeSysTenant(HttpServletRequest request) {
        CloudtOptional<SysTenantDTO> tenant;
        String domain;
        CloudtOptional<SysTenantDTO> tenant2;
        String tenantId;
        GeneralUserDetails user = SecurityUtil.getUser();
        if (user != null && user.getTenant() != null) {
            if (!StringUtils.hasText((String)user.getTenant().getSchemaName())) {
                return user.getTenant();
            }
            log.warn("\u5f53\u524d\u79df\u6237\u3010{}, {}\u3011\u672a\u8bbe\u7f6eschema\uff01", (Object)user.getTenant().getId(), (Object)user.getTenant().getTenantCode());
        }
        if ((tenantId = request.getHeader("X-Tenant-Id")) != null && (tenant2 = this.tenantProvider.getById(Long.parseLong(tenantId))).isPresent()) {
            return (SysTenantDTO)tenant2.get();
        }
        if (StringUtils.hasText((String)this.clientProperties.getTenantDomain()) && StringUtils.hasText((String)(domain = this.obtainDomain(request.getRequestURL().toString()))) && (tenant = this.tenantProvider.getByDomain(domain)).isPresent()) {
            return (SysTenantDTO)tenant.get();
        }
        return null;
    }

    private String obtainDomain(String url) {
        boolean isHttpProtocol = false;
        if (url.startsWith("http://")) {
            url = url.substring(7);
            isHttpProtocol = true;
        } else if (url.startsWith("https://")) {
            url = url.substring(8);
            isHttpProtocol = true;
        }
        if (!isHttpProtocol) {
            return null;
        }
        int lastIndex = url.indexOf("/");
        if (lastIndex > 0) {
            url = url.substring(0, lastIndex);
        }
        url = this.filterChildDomain(url);
        return url;
    }

    private String filterChildDomain(String domain) {
        if (domain == null) {
            return null;
        }
        if (domain.endsWith(this.clientProperties.getTenantDomain())) {
            return domain.substring(0, domain.length() - this.clientProperties.getTenantDomain().length() - 1);
        }
        return domain;
    }
}

