/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.provider;

import com.elitesland.cloudt.tenant.rpc.TenantRpcProvider;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.common.CloudtOptional;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.dto.SysTenantDTO;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.util.StringUtils;

public class TenantProvider {
    private static final Logger log = LogManager.getLogger(TenantProvider.class);
    private final TenantRpcProvider tenantRpcProvider;
    private static final Map<String, SysTenantDTO> ALL = new HashMap<String, SysTenantDTO>();
    private static final Map<String, SysTenantDTO> DOMAIN_TENANT = new HashMap<String, SysTenantDTO>();
    private static final Map<String, SysTenantDTO> DOMAIN_CUSTOM_TENANT = new HashMap<String, SysTenantDTO>();

    public TenantProvider(TenantRpcProvider tenantRpcProvider) {
        this.tenantRpcProvider = tenantRpcProvider;
    }

    @Cacheable(value={"yst_tenant"}, key="'ALL'")
    public Map<String, SysTenantDTO> getAllTenant() {
        this.queryTenant();
        return Collections.unmodifiableMap(ALL);
    }

    @Cacheable(value={"yst_tenant"}, key="#p0")
    public CloudtOptional<SysTenantDTO> getById(Long id) {
        this.queryTenant();
        return CloudtOptional.of((Serializable)ALL.get(id.toString()));
    }

    @Cacheable(value={"yst_tenant"}, key="#p0")
    public CloudtOptional<SysTenantDTO> getByDomain(String domain) {
        this.queryTenant();
        SysTenantDTO tenantDTO = DOMAIN_CUSTOM_TENANT.get(domain);
        if (tenantDTO != null) {
            return CloudtOptional.of((Serializable)tenantDTO);
        }
        return CloudtOptional.of((Serializable)tenantDTO);
    }

    private void queryTenant() {
        ALL.clear();
        DOMAIN_TENANT.clear();
        DOMAIN_CUSTOM_TENANT.clear();
        ApiResult<List<SysTenantDTO>> queryTenantResult = this.tenantRpcProvider.allTenants();
        if (!queryTenantResult.isSuccess() || queryTenantResult.getData() == null) {
            throw new BusinessException("\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + queryTenantResult.getMsg() + "\uff1b" + queryTenantResult.getErrorMsg());
        }
        List tenants = (List)queryTenantResult.getData();
        if (tenants.isEmpty()) {
            log.warn("\u6682\u65e0\u79df\u6237\u4fe1\u606f");
            return;
        }
        for (SysTenantDTO tenant : tenants) {
            this.cacheTenant(tenant);
        }
    }

    private void cacheTenant(SysTenantDTO tenant) {
        if (tenant == null) {
            return;
        }
        ALL.put(tenant.getId().toString(), tenant);
        if (StringUtils.hasText((String)tenant.getTenantDomain())) {
            DOMAIN_TENANT.put(tenant.getTenantName(), tenant);
        }
        if (StringUtils.hasText((String)tenant.getTenantCustomDomain())) {
            DOMAIN_CUSTOM_TENANT.put(tenant.getTenantCustomDomain(), tenant);
        }
    }
}

