/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.transaction;

import com.elitesland.cloudt.tenant.TenantClient;
import com.elitesland.cloudt.tenant.config.datasource.TenantSession;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.util.Assert;

@Aspect
public class TenantTransactionAspect {
    private static final Logger log = LogManager.getLogger(TenantTransactionAspect.class);

    @Pointcut(value="@annotation(com.elitesland.yst.core.annotation.TenantTransaction)")
    private void pointCutMethod() {
    }

    @Pointcut(value="@within(com.elitesland.yst.core.annotation.TenantTransaction)")
    private void pointCutClass() {
    }

    @Around(value="pointCutClass() || pointCutMethod()")
    public Object cutAround(ProceedingJoinPoint point) throws Throwable {
        if (TenantSession.getUseDefaultSchema()) {
            return point.proceed();
        }
        TenantTransaction annotation = this.obtainAnnotation(point);
        Assert.notNull((Object)annotation, (String)"\u672a\u83b7\u53d6\u5230TenantTransaction\u6ce8\u89e3\u4fe1\u606f");
        GeneralUserDetails user = SecurityUtil.getUser();
        if (annotation.defaultSchema() || user != null && user.isSystemAdmin()) {
            return this.cutForDefaultSchema(point);
        }
        return this.cutForTenantSchema(point, annotation.tenantRequired());
    }

    private TenantTransaction obtainAnnotation(ProceedingJoinPoint point) {
        if (point instanceof MethodInvocationProceedingJoinPoint) {
            TenantTransaction annotation = ((MethodSignature)point.getSignature()).getMethod().getAnnotation(TenantTransaction.class);
            if (annotation == null) {
                annotation = point.getThis().getClass().getAnnotation(TenantTransaction.class);
            }
            return annotation;
        }
        return null;
    }

    private Object cutForDefaultSchema(ProceedingJoinPoint point) throws Throwable {
        TenantSession.setUseDefaultSchema();
        try {
            Object object = point.proceed();
            return object;
        }
        finally {
            TenantSession.clearUseDefaultSchema();
        }
    }

    private Object cutForTenantSchema(ProceedingJoinPoint point, boolean requiredTenant) throws Throwable {
        TenantSession.clearUseDefaultSchema();
        if (TenantClient.getCurrentTenant() == null && TenantSession.getCurrentTenant() == null) {
            if (requiredTenant) {
                throw new BusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u79df\u6237\u4fe1\u606f");
            }
            log.warn("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u79df\u6237\u4fe1\u606f");
        }
        return point.proceed();
    }
}

