/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.transaction;

import com.elitesland.cloudt.context.transaction.TransactionWrapper;
import com.elitesland.cloudt.tenant.TenantClient;
import com.elitesland.cloudt.tenant.config.datasource.TenantSession;
import com.elitesland.yst.security.common.InnerUserEnum;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.dto.SysTenantDTO;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Assert;

public class TenantTransactionWrapper
implements TransactionWrapper<Object, Object> {
    private static final Logger log = LogManager.getLogger(TenantTransactionWrapper.class);

    public Object apply(Callable<Object> runnable, Object subject) {
        SysTenantDTO tenant = null;
        if (subject instanceof SysTenantDTO) {
            tenant = (SysTenantDTO)subject;
        } else if (subject instanceof GeneralUserDetails) {
            GeneralUserDetails user = (GeneralUserDetails)subject;
            tenant = InnerUserEnum.ADMIN.getUsername().equals(user.getUsername()) ? null : user.getTenant();
        } else if (subject instanceof SysUserDTO) {
            SysUserDTO user = (SysUserDTO)subject;
            if (!InnerUserEnum.ADMIN.getUsername().equals(user.getUsername())) {
                tenant = user.getSysTenantVO();
            }
        } else if (subject instanceof Long) {
            tenant = TenantClient.getTenant((Long)subject);
        } else if (subject != null) {
            throw new IllegalArgumentException("\u672a\u77e5\u53c2\u6570\u7c7b\u578b");
        }
        if (tenant == null) {
            return this.applyDefaultSchema(runnable);
        }
        return this.applyTenantSchema(runnable, tenant);
    }

    private Object applyDefaultSchema(Callable<Object> runnable) {
        TenantSession.setUseDefaultSchema();
        try {
            Object object = runnable.call();
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("\u3010\u79df\u6237\u3011\u4e8b\u52a1\u5305\u88c5\u5904\u7406\u5f02\u5e38", e);
        }
        finally {
            TenantSession.clearUseDefaultSchema();
        }
    }

    private Object applyTenantSchema(Callable<Object> runnable, SysTenantDTO tenant) {
        boolean useDefaultSchema = TenantSession.getUseDefaultSchema();
        if (useDefaultSchema) {
            TenantSession.clearUseDefaultSchema();
        }
        SysTenantDTO originalTenant = TenantSession.getCurrentTenant();
        Assert.notNull((Object)tenant, (String)"\u79df\u6237\u4e0d\u5b58\u5728");
        TenantSession.setCurrentTenant(tenant);
        try {
            Object object = runnable.call();
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("\u3010\u79df\u6237\u3011\u4e8b\u52a1\u5305\u88c5\u5904\u7406\u5f02\u5e38", e);
        }
        finally {
            if (originalTenant == null) {
                TenantSession.clearCurrent();
            } else {
                TenantSession.setCurrentTenant(originalTenant);
            }
            if (useDefaultSchema) {
                TenantSession.setUseDefaultSchema();
            }
        }
    }
}

