package com.elitesland.cloudt.tenant.config;

import com.elitesland.cloudt.tenant.core.common.ConstantTenant;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;

/**
 * 租户客户端配置属性.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/24
 */
@ConfigurationProperties(prefix = TenantClientProperties.CONFIG_PREFIX)
public class TenantClientProperties {

    public static final String CONFIG_PREFIX = ConstantTenant.CONFIG_SERVICE_PREFIX + ".client";

    /**
     * 是否启用客户端
     */
    private boolean enabled = true;

    /**
     * 租户路径拦截
     */
    private String pathPattern = "/**";

    /**
     * 默认schema
     */
    private String defaultSchema;

    /**
     * 租户域名地址
     */
    private String tenantDomain = "tenant.elitesland.com";
    /**
     * 租户域名与我们的域名直接的分隔符
     */
    private String tenantDomainDelimiter = ".";

    /**
     * 同步数据库信息重试次数，默认3次
     */
    private int syncDbRetryTimes = 3;

    /**
     * 失败后重试间隔，默认1分钟
     */
    private Duration retryInterval = Duration.ofMinutes(2);

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getPathPattern() {
        return pathPattern;
    }

    public void setPathPattern(String pathPattern) {
        this.pathPattern = pathPattern;
    }

    public String getDefaultSchema() {
        return defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public String getTenantDomain() {
        return tenantDomain;
    }

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public String getTenantDomainDelimiter() {
        return tenantDomainDelimiter;
    }

    public void setTenantDomainDelimiter(String tenantDomainDelimiter) {
        this.tenantDomainDelimiter = tenantDomainDelimiter;
    }

    public int getSyncDbRetryTimes() {
        return syncDbRetryTimes;
    }

    public void setSyncDbRetryTimes(int syncDbRetryTimes) {
        this.syncDbRetryTimes = syncDbRetryTimes;
    }

    public Duration getRetryInterval() {
        return retryInterval;
    }

    public void setRetryInterval(Duration retryInterval) {
        this.retryInterval = retryInterval;
    }
}
