package com.elitesland.cloudt.tenant.config.datasource;

import com.elitesland.yst.system.dto.SysTenantDTO;
import org.springframework.util.Assert;

/**
 * 租户数据库session.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/6
 */
public class TenantSession {

    private static final ThreadLocal<SysTenantDTO> CURRENT_TENANT = new ThreadLocal<>();
    private static final ThreadLocal<Boolean> USE_DEFAULT_SCHEMA = new ThreadLocal<>();

    private TenantSession() {
    }

    /**
     * 获取当前租户信息
     *
     * @return 租户信息
     */
    public static SysTenantDTO getCurrentTenant() {
        return CURRENT_TENANT.get();
    }

    /**
     * 设置当前租户信息
     *
     * @param tenant 租户信息
     */
    public static void setCurrentTenant(SysTenantDTO tenant) {
        Assert.notNull(tenant, "当前租户信息为空");
        CURRENT_TENANT.set(tenant);
    }

    /**
     * 清除当前租户信息
     */
    public static void clearCurrent() {
        CURRENT_TENANT.remove();
    }

    /**
     * 获取是否使用默认schema
     *
     * @return 是否使用默认schema
     */
    public static boolean getUseDefaultSchema() {
        var val = USE_DEFAULT_SCHEMA.get();
        return val != null && val;
    }

    /**
     * 设置使用默认schema
     */
    public static void setUseDefaultSchema() {
        USE_DEFAULT_SCHEMA.set(true);
    }

    /**
     * 清楚使用默认schema
     */
    public static void clearUseDefaultSchema() {
        USE_DEFAULT_SCHEMA.remove();
    }
}
