package com.elitesland.cloudt.tenant.config.datasource.hibernate;

import com.elitesland.cloudt.tenant.config.support.TenantContextHolder;
import lombok.extern.log4j.Log4j2;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.springframework.util.StringUtils;

/**
 * 多租户id处理.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/25
 */
@Log4j2
public class HibernateTenantIdentifierResolver implements CurrentTenantIdentifierResolver {

    @Override
    public String resolveCurrentTenantIdentifier() {
        var tenant = TenantContextHolder.getCurrentTenant();
        if (tenant != null && StringUtils.hasText(tenant.getSchemaName())) {
            return tenant.getId().toString();
        }

        return TenantContextHolder.ANONYMOUS_IDENTIFIER;
    }

    @Override
    public boolean validateExistingCurrentSessions() {
        return true;
    }
}
