package com.elitesland.cloudt.tenant.config.support;

import com.elitesland.yst.system.dto.SysTenantDTO;
import org.springframework.util.Assert;

/**
 * 租户上下文信息工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/26
 */
public class TenantContextHolder {

    private TenantContextHolder() {
    }

    /**
     * 匿名租户的ID标识
     */
    public static final String ANONYMOUS_IDENTIFIER = "anonymous";

    /**
     * 租户上下文
     */
    private static final ThreadLocal<SysTenantDTO> CURRENT_TENANT = new ThreadLocal<>();

    /**
     * 获取当前租户信息
     *
     * @return 租户信息
     */
    public static SysTenantDTO getCurrentTenant() {
        return CURRENT_TENANT.get();
    }

    /**
     * 设置当前租户信息
     *
     * @param tenant 租户信息
     */
    public static void setCurrentTenant(SysTenantDTO tenant) {
        Assert.notNull(tenant, "当前租户信息为空");
        CURRENT_TENANT.set(tenant);
    }

    /**
     * 清除当前租户信息
     */
    public static void clearCurrent() {
        CURRENT_TENANT.remove();
    }
}
