package com.elitesland.cloudt.tenant.config.support;

import com.elitesland.cloudt.tenant.util.TenantRequestUtil;
import lombok.extern.log4j.Log4j2;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 租户请求拦截器.
 * <p>
 * 主要用于设置租户上下文信息
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/26
 */
@Log4j2
public class TenantRequestInterceptor implements AsyncHandlerInterceptor {

    @Override
    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        var tenant = TenantRequestUtil.obtainTenant(request);
        if (tenant != null) {
            TenantContextHolder.setCurrentTenant(tenant);
        }
        return true;
    }

    @Override
    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        TenantContextHolder.clearCurrent();
    }
}
