package com.elitesland.cloudt.tenant.initializer;

import com.elitesland.cloudt.tenant.provider.ClientSyncTenantProvider;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.task.TaskExecutor;

/**
 * 租户schema初始化.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/24
 */
@Log4j2
public class TenantSchemaInitializer implements CommandLineRunner {

    private final ClientSyncTenantProvider clientSyncTenantProvider;
    private final TaskExecutor taskExecutor;

    public TenantSchemaInitializer(ClientSyncTenantProvider clientSyncTenantProvider, TaskExecutor taskExecutor) {
        this.clientSyncTenantProvider = clientSyncTenantProvider;
        this.taskExecutor = taskExecutor;
    }

    @Override
    public void run(String... args) throws Exception {
        taskExecutor.execute(this::syncClientInfo);
    }

    private void syncClientInfo() {
        log.info("开始同步客户端租户数据表结构...");
        clientSyncTenantProvider.sync();
        log.info("同步客户端租户数据表结构结束！");
    }
}
