package com.elitesland.cloudt.tenant.rpc;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.system.dto.SysTenantDTO;

import java.util.List;

/**
 * 租户RPC服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/24
 */
public interface TenantRpcProvider {

    /**
     * 查询所有租户信息
     *
     * @return 租户信息
     */
    ApiResult<List<SysTenantDTO>> allTenants();

    /**
     * 根据ID获取租户信息
     *
     * @param id 租户ID
     * @return 租户信息
     */
    ApiResult<SysTenantDTO> getById(Long id);
}
