package com.elitesland.cloudt.tenant.rpc.consumer;

import com.elitesland.cloudt.context.flyway.FlywayBuilder;
import com.elitesland.cloudt.context.flyway.support.FlywayHelper;
import com.elitesland.cloudt.tenant.config.datasource.AbstractTenantDatasourceProvider;
import com.elitesland.yst.common.base.ApiResult;
import lombok.extern.log4j.Log4j2;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 租户数据库变更接收者.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/25
 */
@DubboService
@Log4j2
public class TenantDatabaseRpcProviderImpl implements TenantDatabaseRpcProvider {

    @Autowired
    private FlywayBuilder flywayBuilder;
    @Autowired
    private FlywayHelper flywayHelper;

    @Override
    public ApiResult<Boolean> schemaCreate(String schema) {
        log.info("创建新租户schema：{}", schema);

        try {
            flywayHelper.migrate(() -> flywayBuilder.createFlywayForTenant(AbstractTenantDatasourceProvider.getDefaultSchema(), schema));
        } catch (Exception e) {
            log.error("创建租户schema异常：", e);
            return ApiResult.fail(e.getMessage());
        }

        log.info("创建新租户schema：【{}】成功！", schema);
        return ApiResult.ok(true);
    }
}
