/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant;

import com.elitesland.cloudt.context.SpringContextHolder;
import com.elitesland.cloudt.tenant.config.datasource.TenantSession;
import com.elitesland.cloudt.tenant.config.support.TenantContextHolder;
import com.elitesland.cloudt.tenant.provider.TenantProvider;
import com.elitesland.yst.common.common.CloudtOptional;
import com.elitesland.yst.system.dto.SysTenantDTO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Assert;

public class TenantClient {
    private static final Logger log = LogManager.getLogger(TenantClient.class);
    private static TenantProvider tenantProvider;

    private TenantClient() {
    }

    public static SysTenantDTO getCurrentTenant() {
        return TenantContextHolder.getCurrentTenant();
    }

    public static SysTenantDTO getTenant(Long tenantId) {
        if (tenantId == null) {
            return null;
        }
        return (SysTenantDTO)TenantClient.getTenantProvider().getById(tenantId).get();
    }

    public static void switchTraditionalForTenant(Long tenantId) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237ID\u4e3a\u7a7a");
        CloudtOptional<SysTenantDTO> tenant = TenantClient.getTenantProvider().getById(tenantId);
        Assert.isTrue((boolean)tenant.isPresent(), (String)"\u79df\u6237\u4e0d\u5b58\u5728");
        TenantSession.setCurrentTenant((SysTenantDTO)tenant.get());
        TenantSession.clearUseDefaultSchema();
    }

    public static void switchTenantForTenantCurrent() {
        TenantSession.clearCurrent();
        TenantSession.clearUseDefaultSchema();
    }

    public static void switchTenantForTenantDefault() {
        TenantSession.clearCurrent();
        TenantSession.setUseDefaultSchema();
    }

    private static TenantProvider getTenantProvider() {
        if (tenantProvider == null) {
            tenantProvider = (TenantProvider)SpringContextHolder.getBean(TenantProvider.class);
        }
        return tenantProvider;
    }
}

