/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config;

import com.elitesland.cloudt.context.flyway.FlywayBuilder;
import com.elitesland.cloudt.context.flyway.FlywayCloudtAutoConfiguration;
import com.elitesland.cloudt.context.flyway.support.FlywayHelper;
import com.elitesland.cloudt.context.transaction.TransactionWrapper;
import com.elitesland.cloudt.tenant.config.TenantClientProperties;
import com.elitesland.cloudt.tenant.config.support.TenantContextTransfer;
import com.elitesland.cloudt.tenant.config.support.TenantRequestInterceptor;
import com.elitesland.cloudt.tenant.initializer.TenantSchemaInitializer;
import com.elitesland.cloudt.tenant.provider.ClientSyncTenantProvider;
import com.elitesland.cloudt.tenant.provider.TenantProvider;
import com.elitesland.cloudt.tenant.rpc.TenantRpcProvider;
import com.elitesland.cloudt.tenant.transaction.TenantTransactionAspect;
import com.elitesland.cloudt.tenant.transaction.TenantTransactionWrapper;
import com.elitesland.cloudt.tenant.transaction.TransactionExecutor;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.task.TaskExecutor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnProperty(prefix="elitesland.tenant.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={TenantClientProperties.class})
@AutoConfigureAfter(value={FlywayCloudtAutoConfiguration.class})
@Import(value={TenantWebServletConfiguration.class})
public class CloudtTenantClientAutoConfiguration {
    private final TenantClientProperties clientProperties;
    @DubboReference
    private TenantRpcProvider tenantRpcProvider;

    public CloudtTenantClientAutoConfiguration(TenantClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    @Bean
    public TenantProvider tenantProvider() {
        return new TenantProvider(this.tenantRpcProvider);
    }

    @Bean
    public ClientSyncTenantProvider clientSyncTenantProvider(TenantProvider tenantProvider, FlywayHelper flywayHelper, FlywayBuilder flywayBuilder) {
        return new ClientSyncTenantProvider(this.clientProperties, tenantProvider, flywayHelper, flywayBuilder);
    }

    @Bean
    public TenantSchemaInitializer tenantSchemaInitializer(ClientSyncTenantProvider clientSyncTenantProvider, TaskExecutor taskExecutor) {
        return new TenantSchemaInitializer(clientSyncTenantProvider, taskExecutor);
    }

    @Bean
    public TenantRequestInterceptor tenantRequestInterceptor() {
        return new TenantRequestInterceptor();
    }

    @Bean
    public TenantContextTransfer tenantContextTransfer() {
        return new TenantContextTransfer();
    }

    @Bean
    public TransactionExecutor transactionExecutor() {
        return new TransactionExecutor();
    }

    @Bean(value={"tenantTransactionWrapper"})
    @Primary
    public TransactionWrapper tenantTransactionWrapper(TransactionExecutor executor) {
        return new TenantTransactionWrapper(executor);
    }

    @ConditionalOnProperty(prefix="elitesland.tenant.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class TenantAopConfig {
        @Bean
        public TenantTransactionAspect tenantTransactionAspect() {
            return new TenantTransactionAspect();
        }
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class TenantWebServletConfiguration
    implements WebMvcConfigurer {
        private final TenantClientProperties clientProperties;
        private final TenantRequestInterceptor tenantRequestInterceptor;

        public TenantWebServletConfiguration(TenantClientProperties clientProperties, TenantRequestInterceptor tenantRequestInterceptor) {
            this.clientProperties = clientProperties;
            this.tenantRequestInterceptor = tenantRequestInterceptor;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.tenantRequestInterceptor).addPathPatterns(new String[]{this.clientProperties.getPathPattern()});
        }
    }
}

