/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.datasource;

import com.elitesland.yst.system.dto.SysTenantDTO;
import org.springframework.util.Assert;

public class TenantSession {
    private static final ThreadLocal<SysTenantDTO> CURRENT_TENANT = new ThreadLocal();
    private static final ThreadLocal<Boolean> USE_DEFAULT_SCHEMA = new ThreadLocal();

    private TenantSession() {
    }

    public static SysTenantDTO getCurrentTenant() {
        return CURRENT_TENANT.get();
    }

    public static void setCurrentTenant(SysTenantDTO tenant) {
        Assert.notNull((Object)tenant, (String)"\u5f53\u524d\u79df\u6237\u4fe1\u606f\u4e3a\u7a7a");
        CURRENT_TENANT.set(tenant);
    }

    public static void clearCurrent() {
        CURRENT_TENANT.remove();
    }

    public static boolean getUseDefaultSchema() {
        Boolean val = USE_DEFAULT_SCHEMA.get();
        return val != null && val != false;
    }

    public static void setUseDefaultSchema() {
        USE_DEFAULT_SCHEMA.set(true);
    }

    public static void clearUseDefaultSchema() {
        USE_DEFAULT_SCHEMA.remove();
    }
}

