/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.filter;

import com.elitesland.cloudt.tenant.TenantClient;
import com.elitesland.cloudt.tenant.config.support.TenantContextHolder;
import com.elitesland.cloudt.tenant.util.TenantRequestUtil;
import com.elitesland.yst.system.dto.SysTenantDTO;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Activate(group={"provider", "consumer"})
public class DubboTenantContextFilter
implements Filter {
    private static final Logger log = LogManager.getLogger(DubboTenantContextFilter.class);
    private static final String ATTACHMENT_KEY = "cloudt_tenant_id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RpcContext rpcContext = RpcContext.getContext();
        if (rpcContext.isProviderSide()) {
            SysTenantDTO tenantDTO = null;
            String tenantId = rpcContext.getAttachment(ATTACHMENT_KEY);
            if (tenantId != null && tenantId.length() > 0 && (tenantDTO = TenantClient.getTenant(Long.parseLong(tenantId))) != null) {
                this.setTenant(tenantDTO);
                log.info("\u5f53\u524d\u79df\u6237\uff1a{}", (Object)tenantDTO.getTenantCode());
            }
            try {
                Result result = invoker.invoke(invocation);
                return result;
            }
            finally {
                if (tenantDTO != null) {
                    this.clearTenant();
                }
            }
        }
        SysTenantDTO tenantDTO = this.obtainTenant();
        if (tenantDTO != null) {
            rpcContext.setAttachment(ATTACHMENT_KEY, tenantDTO.getId().toString());
        }
        return invoker.invoke(invocation);
    }

    private SysTenantDTO obtainTenant() {
        SysTenantDTO tenantDTO = TenantContextHolder.getCurrentTenant();
        if (tenantDTO != null) {
            return tenantDTO;
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            return TenantRequestUtil.obtainTenant(((ServletRequestAttributes)requestAttributes).getRequest());
        }
        return null;
    }

    private void setTenant(SysTenantDTO tenant) {
        TenantContextHolder.setCurrentTenant(tenant);
    }

    private void clearTenant() {
        TenantContextHolder.clearCurrent();
    }
}

