/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.util;

import com.elitesland.cloudt.context.SpringContextHolder;
import com.elitesland.cloudt.tenant.config.TenantClientProperties;
import com.elitesland.cloudt.tenant.provider.TenantProvider;
import com.elitesland.yst.common.common.CloudtOptional;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.dto.SysTenantDTO;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class TenantRequestUtil {
    private static final Logger log = LogManager.getLogger(TenantRequestUtil.class);
    private static TenantClientProperties clientProperties;
    private static TenantProvider tenantProvider;

    private TenantRequestUtil() {
    }

    public static String obtainTenantDomain(String url) {
        String defaultDomain;
        boolean isHttpProtocol = false;
        if (url.startsWith("http://")) {
            url = url.substring(7);
            isHttpProtocol = true;
        } else if (url.startsWith("https://")) {
            url = url.substring(8);
            isHttpProtocol = true;
        }
        if (!isHttpProtocol) {
            return null;
        }
        int lastIndex = url.indexOf("/");
        if (lastIndex > 0) {
            url = url.substring(0, lastIndex);
        }
        if ((lastIndex = url.indexOf(":")) > 0) {
            url = url.substring(0, lastIndex);
        }
        if (StringUtils.hasText((String)(defaultDomain = TenantRequestUtil.getClientProperties().getTenantDomain()))) {
            url = TenantRequestUtil.filterChildDomain(url, defaultDomain);
        }
        return url;
    }

    public static SysTenantDTO obtainTenant(HttpServletRequest request) {
        String domain;
        GeneralUserDetails user = SecurityUtil.getUser();
        if (user != null && user.getTenant() != null) {
            return user.getTenant();
        }
        String tenantId = request.getHeader("X-Tenant-Id");
        if (tenantId != null) {
            CloudtOptional<SysTenantDTO> tenant = TenantRequestUtil.getTenantProvider().getById(Long.parseLong(tenantId));
            return (SysTenantDTO)tenant.orElseThrow((Supplier)new BusinessException("\u79df\u6237\u4e0d\u5b58\u5728"));
        }
        if (StringUtils.hasText((String)TenantRequestUtil.getClientProperties().getTenantDomain()) && StringUtils.hasText((String)(domain = TenantRequestUtil.obtainTenantDomain(request.getRequestURL().toString())))) {
            CloudtOptional<SysTenantDTO> tenant = TenantRequestUtil.getTenantProvider().getByDomain(domain);
            return (SysTenantDTO)tenant.orElseThrow((Supplier)new BusinessException("\u672a\u77e5\u57df\u540d\u6240\u7ed1\u5b9a\u7684\u79df\u6237"));
        }
        return null;
    }

    public static TenantClientProperties getClientProperties() {
        if (clientProperties == null) {
            clientProperties = (TenantClientProperties)SpringContextHolder.getBean(TenantClientProperties.class);
        }
        return clientProperties;
    }

    public static TenantProvider getTenantProvider() {
        if (tenantProvider == null) {
            tenantProvider = (TenantProvider)SpringContextHolder.getBean(TenantProvider.class);
        }
        return tenantProvider;
    }

    private static String filterChildDomain(String domain, String defaultDomain) {
        if (domain == null) {
            return null;
        }
        if (domain.endsWith(defaultDomain)) {
            int end = domain.length() - defaultDomain.length() - 1;
            if (end <= 0) {
                return domain;
            }
            return domain.substring(0, end);
        }
        return domain;
    }
}

