/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.support;

import com.elitesland.cloudt.tenant.TenantClient;
import com.elitesland.cloudt.tenant.config.support.TenantSession;
import com.elitesland.yst.common.base.BaseCallbackWrapper;
import com.elitesland.yst.common.constant.TenantType;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.dto.SysTenantDTO;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractTenantIsolateDelegate<T, R, E>
implements BaseCallbackWrapper<T, R> {
    private static final Logger log = LogManager.getLogger(AbstractTenantIsolateDelegate.class);

    protected abstract boolean supportApply(SysTenantDTO var1);

    protected abstract E beforeApply(Callable<R> var1, SysTenantDTO var2);

    protected abstract void afterCompletion(R var1, E var2, boolean var3, Exception var4);

    public R apply(Callable<R> runnable, T param) throws Exception {
        SysTenantDTO tenant = this.convertSubject(param);
        if (!this.supportApply(tenant)) {
            return runnable.call();
        }
        if (tenant == null || tenant.getType() == TenantType.OPERATION) {
            return this.applyDefault(runnable);
        }
        return this.applyTenant(runnable, tenant);
    }

    private SysTenantDTO convertSubject(T subject) {
        if (subject == null) {
            return null;
        }
        if (subject instanceof SysTenantDTO) {
            return (SysTenantDTO)subject;
        }
        if (subject instanceof GeneralUserDetails) {
            GeneralUserDetails user = (GeneralUserDetails)subject;
            return user.getTenant();
        }
        if (subject instanceof SysUserDTO) {
            SysUserDTO user = (SysUserDTO)subject;
            return user.getSysTenantVO();
        }
        if (subject instanceof Long) {
            return TenantClient.getTenant((Long)subject);
        }
        throw new IllegalArgumentException("\u672a\u77e5\u4e3b\u4f53\u7c7b\u578b");
    }

    private R applyDefault(Callable<R> runnable) throws Exception {
        boolean hasUsedDefault = TenantSession.getUseDefault();
        if (hasUsedDefault) {
            return runnable.call();
        }
        TenantSession.setUseDefault();
        E customParam = null;
        try {
            customParam = this.beforeApply(runnable, null);
            R result = runnable.call();
            this.executeCompletion(result, customParam, true, null);
            R r = result;
            return r;
        }
        catch (Exception e) {
            this.executeCompletion(null, customParam, true, e);
            if (e instanceof BusinessException || e instanceof IllegalArgumentException) {
                throw new BusinessException(e.getMessage());
            }
            throw new RuntimeException(e);
        }
        finally {
            TenantSession.clearUseDefault();
        }
    }

    private R applyTenant(Callable<R> runnable, SysTenantDTO tenant) throws Exception {
        boolean hasUsedDefault = TenantSession.getUseDefault();
        if (hasUsedDefault) {
            TenantSession.clearUseDefault();
        }
        SysTenantDTO hasUsedTenant = TenantSession.getCurrentTenant();
        TenantSession.setCurrentTenant(tenant);
        E customParam = null;
        try {
            customParam = this.beforeApply(runnable, tenant);
            R result = runnable.call();
            this.executeCompletion(result, customParam, false, null);
            R r = result;
            return r;
        }
        catch (Exception e) {
            this.executeCompletion(null, customParam, false, e);
            if (e instanceof BusinessException || e instanceof IllegalArgumentException) {
                throw new BusinessException(e.getMessage());
            }
            throw new RuntimeException(e);
        }
        finally {
            if (hasUsedTenant == null) {
                TenantSession.clearCurrentTenant();
            } else {
                TenantSession.setCurrentTenant(hasUsedTenant);
            }
            if (hasUsedDefault) {
                TenantSession.setUseDefault();
            }
        }
    }

    private void executeCompletion(R result, E customParam, boolean useDefault, Exception exp) {
        try {
            this.afterCompletion(result, customParam, useDefault, exp);
        }
        catch (Exception e) {
            log.error("\u6267\u884ccompletion\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

