/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.support;

import com.elitesland.cloudt.context.base.AbstractEnvironmentPostProcessor;
import com.elitesland.cloudt.tenant.config.datasource.hibernate.HibernateTenantDatasourceProvider;
import com.elitesland.cloudt.tenant.config.datasource.hibernate.HibernateTenantIdentifierResolver;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.MultiTenancyStrategy;
import org.springframework.boot.SpringApplication;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.util.CollectionUtils;

public class TenantEnvironmentDefaultConfig
extends AbstractEnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        Map<String, Object> defaultProperties = this.createDefaultProperties(environment);
        if (!CollectionUtils.isEmpty(defaultProperties)) {
            this.addOrReplace(propertySources, defaultProperties);
        }
    }

    private Map<String, Object> createDefaultProperties(ConfigurableEnvironment environment) {
        HashMap<String, Object> defaultProperties = new HashMap<String, Object>(8);
        defaultProperties.put("spring.jpa.properties.hibernate.multiTenancy", MultiTenancyStrategy.SCHEMA.name());
        defaultProperties.put("spring.jpa.properties.hibernate.tenant_identifier_resolver", HibernateTenantIdentifierResolver.class.getName());
        defaultProperties.put("spring.jpa.properties.hibernate.multi_tenant_connection_provider", HibernateTenantDatasourceProvider.class.getName());
        defaultProperties.put("spring.jpa.hibernate.ddl-auto", "none");
        defaultProperties.put("spring.jpa.properties.hibernate.hbm2ddl.auto", "none");
        return defaultProperties;
    }
}

