/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.datasource;

import com.elitesland.cloudt.tenant.config.datasource.AbstractTenantDatasourceProvider;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
public class TenantDataSourceListener
implements SmartApplicationListener,
InitializingBean {
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType.isAssignableFrom(ApplicationContextInitializedEvent.class);
    }

    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        if (event instanceof ApplicationContextInitializedEvent) {
            ConfigurableEnvironment env = ((ApplicationContextInitializedEvent)event).getApplicationContext().getEnvironment();
            DataSource dataSource = this.loadingDataSource((Environment)env);
            this.loadingDefaultSchema((Environment)env);
            this.loadingDatabase((Environment)env, dataSource);
        }
    }

    public void afterPropertiesSet() throws Exception {
    }

    private Database loadingDatabase(Environment env, DataSource dataSource) {
        Database database = null;
        if (dataSource instanceof HikariDataSource && (database = AbstractTenantDatasourceProvider.getDatabaseTypeByUrl(((HikariDataSource)dataSource).getJdbcUrl())) != null) {
            AbstractTenantDatasourceProvider.setDatabaseType(database);
            return database;
        }
        String dbTypeStr = env.getProperty("spring.jpa.database");
        if (StringUtils.hasText((String)dbTypeStr)) {
            try {
                database = Database.valueOf((String)dbTypeStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            if (database != null) {
                AbstractTenantDatasourceProvider.setDatabaseType(database);
                return database;
            }
        }
        return database;
    }

    private String loadingDefaultSchema(Environment env) {
        String schema = env.getProperty("elitesland.tenant.client.default-schema");
        if (StringUtils.hasText((String)schema)) {
            AbstractTenantDatasourceProvider.setDefaultSchema(schema);
        }
        return schema;
    }

    private DataSource loadingDataSource(Environment env) {
        DataSource dataSource = this.loadDataSourceBySharding(env);
        if (dataSource == null) {
            dataSource = this.loadDataSourceByHikari(env);
        }
        AbstractTenantDatasourceProvider.setDefaultDataSource(dataSource);
        return dataSource;
    }

    private DataSource loadDataSourceBySharding(Environment env) {
        String prefix = "spring.shardingsphere.datasource.";
        String datasourceName = env.getProperty(prefix + "name");
        if (!StringUtils.hasText((String)datasourceName) && StringUtils.hasText((String)(datasourceName = env.getProperty(prefix + "names")))) {
            datasourceName = datasourceName.split(",")[0];
        }
        if (!StringUtils.hasText((String)datasourceName)) {
            return null;
        }
        String datasourceKey = prefix + datasourceName.trim();
        String datasourceType = env.getProperty(datasourceKey + ".type");
        Assert.hasText((String)datasourceType, (String)"\u672a\u77e5shardingSphere\u914d\u7f6e\u7684\u6570\u636e\u6e90\u7c7b\u578b");
        Class<?> dataSourceClass = null;
        try {
            dataSourceClass = Class.forName(datasourceType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("\u672a\u627e\u5230\u6570\u636e\u6e90\u7c7b\u578bclass\uff1a" + datasourceType, e);
        }
        BindResult dataSourceBindResult = Binder.get((Environment)env).bind(datasourceKey, dataSourceClass);
        if (dataSourceBindResult.isBound()) {
            return (DataSource)dataSourceBindResult.get();
        }
        throw new RuntimeException("\u521d\u59cb\u5316\u6570\u636e\u6e90\u5931\u8d25");
    }

    private HikariDataSource loadDataSourceByHikari(Environment env) {
        String prefix = "spring.datasource.hikari";
        String jdbcUrl = env.getProperty(prefix + ".jdbc-url");
        if (!StringUtils.hasText((String)jdbcUrl)) {
            return null;
        }
        BindResult dataSourceBindResult = Binder.get((Environment)env).bind(prefix, HikariDataSource.class);
        if (dataSourceBindResult.isBound()) {
            return (HikariDataSource)dataSourceBindResult.get();
        }
        throw new RuntimeException("\u521d\u59cb\u5316\u6570\u636e\u6e90\u5931\u8d25");
    }
}

