/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.datasource.hibernate;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.cloudt.tenant.config.datasource.AbstractTenantDatasourceProvider;
import com.elitesland.cloudt.tenant.config.support.TenantContextHolder;
import com.elitesland.cloudt.tenant.config.support.TenantSession;
import com.elitesland.yst.system.dto.SysTenantDTO;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.engine.jdbc.connections.spi.AbstractDataSourceBasedMultiTenantConnectionProviderImpl;
import org.springframework.orm.jpa.vendor.Database;

public class HibernateTenantDatasourceProvider
extends AbstractDataSourceBasedMultiTenantConnectionProviderImpl {
    private static final Logger log = LogManager.getLogger(HibernateTenantDatasourceProvider.class);
    private static final long serialVersionUID = -3009600657851822507L;
    private final Map<String, Database> databaseMapMap = new HashMap<String, Database>();

    public Connection getConnection(String tenantIdentifier) throws SQLException {
        Connection connection = super.getConnection(tenantIdentifier);
        String schema = this.getTenantSchema();
        Database database = this.getDatabaseType(tenantIdentifier);
        log.debug("use schema '{}' for tenant '{}'", (Object)schema, (Object)tenantIdentifier);
        String command = AbstractTenantDatasourceProvider.generateSwitchSchemaSql(database, schema);
        try (Statement statement = connection.createStatement();){
            statement.execute(command);
        }
        return connection;
    }

    protected DataSource selectAnyDataSource() {
        return AbstractTenantDatasourceProvider.getDefaultDataSource();
    }

    protected DataSource selectDataSource(String tenantIdentifier) {
        return AbstractTenantDatasourceProvider.getDefaultDataSource();
    }

    private String getTenantSchema() {
        boolean useDefault = TenantSession.getUseDefault();
        if (useDefault) {
            return AbstractTenantDatasourceProvider.getDefaultSchema();
        }
        SysTenantDTO tenant = TenantSession.getCurrentTenant();
        if (tenant == null) {
            tenant = TenantContextHolder.getCurrentTenant();
        }
        if (tenant == null) {
            return AbstractTenantDatasourceProvider.getDefaultSchema();
        }
        Object prefix = CharSequenceUtil.isBlank((CharSequence)AbstractTenantDatasourceProvider.getDefaultSchema()) ? "" : AbstractTenantDatasourceProvider.getDefaultSchema() + "_";
        return (String)prefix + tenant.getSchemaName();
    }

    private Database getDatabaseType(String tenantIdentifier) {
        return Optional.ofNullable(tenantIdentifier).map(this.databaseMapMap::get).orElseGet(() -> {
            Database db = AbstractTenantDatasourceProvider.getDatabaseType();
            this.databaseMapMap.put(tenantIdentifier, db);
            return db;
        });
    }
}

