/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.support.transaction;

import com.elitesland.cloudt.context.transaction.TransactionWrapper;
import com.elitesland.cloudt.tenant.config.support.TenantContextHolder;
import com.elitesland.cloudt.tenant.config.support.TenantSession;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.annotation.common.TenantIsolateType;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.dto.SysTenantDTO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

@Aspect
public class TenantTransactionAspect
implements Ordered {
    private static final Logger log = LogManager.getLogger(TenantTransactionAspect.class);
    private final TransactionWrapper tenantTransactionWrapper;

    public TenantTransactionAspect(TransactionWrapper tenantTransactionWrapper) {
        this.tenantTransactionWrapper = tenantTransactionWrapper;
    }

    @Pointcut(value="@annotation(com.elitesland.yst.core.annotation.TenantTransaction)")
    private void pointCutMethod() {
    }

    @Pointcut(value="@within(com.elitesland.yst.core.annotation.TenantTransaction)")
    private void pointCutClass() {
    }

    @Around(value="pointCutClass() || pointCutMethod()")
    public Object cutAround(ProceedingJoinPoint point) throws Throwable {
        TenantTransaction annotation = this.obtainAnnotation(point);
        Assert.notNull((Object)annotation, (String)"\u672a\u83b7\u53d6\u5230TenantTransaction\u6ce8\u89e3\u4fe1\u606f");
        SysTenantDTO tenant = this.obtainTenant(annotation);
        return this.tenantTransactionWrapper.apply(() -> {
            try {
                return point.proceed();
            }
            catch (Throwable e) {
                log.error("\u6267\u884c\u79df\u6237\u76f8\u5173\u4e8b\u52a1\u5f02\u5e38\uff1a", e);
                if (e instanceof BusinessException || e instanceof IllegalArgumentException) {
                    throw new BusinessException(e.getMessage());
                }
                throw new RuntimeException(e);
            }
        }, (Object)tenant);
    }

    private TenantTransaction obtainAnnotation(ProceedingJoinPoint point) {
        if (point instanceof MethodInvocationProceedingJoinPoint) {
            TenantTransaction annotation = ((MethodSignature)point.getSignature()).getMethod().getAnnotation(TenantTransaction.class);
            if (annotation == null) {
                annotation = point.getThis().getClass().getAnnotation(TenantTransaction.class);
            }
            return annotation;
        }
        return null;
    }

    private SysTenantDTO obtainTenant(TenantTransaction annotation) {
        SysTenantDTO currentTenant;
        TenantIsolateType isolateType = annotation.isolateType();
        if (isolateType == TenantIsolateType.DEFAULT) {
            return null;
        }
        SysTenantDTO sessionTenant = TenantSession.getCurrentTenant();
        if (sessionTenant != null) {
            return sessionTenant;
        }
        if (TenantSession.getUseDefault()) {
            return null;
        }
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser != null) {
            if (currentUser.isSystemAdmin() || currentUser.isOperation()) {
                return null;
            }
            currentTenant = currentUser.getTenant();
            if (currentTenant != null) {
                if (isolateType == TenantIsolateType.TENANT) {
                    return currentTenant;
                }
                if (isolateType == TenantIsolateType.TENANT_USER) {
                    return currentUser.isTenantAdmin() ? null : currentTenant;
                }
            }
        }
        currentTenant = TenantContextHolder.getCurrentTenant();
        if (annotation.tenantRequired() && currentTenant == null) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u79df\u6237\u4fe1\u606f");
        }
        return currentTenant;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

