/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant;

import com.elitesland.cloudt.context.SpringContextHolder;
import com.elitesland.cloudt.tenant.config.support.TenantContextHolder;
import com.elitesland.cloudt.tenant.provider.TenantProvider;
import com.elitesland.cloudt.tenant.util.TenantRequestUtil;
import com.elitesland.yst.system.dto.SysTenantDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TenantClient {
    private static final Logger log = LogManager.getLogger(TenantClient.class);
    private static TenantProvider tenantProvider;
    private static final AtomicBoolean INITED;

    private TenantClient() {
    }

    public static boolean enabledTenant() {
        return TenantClient.getTenantProvider() != null;
    }

    public static SysTenantDTO getCurrentTenant() {
        if (!TenantClient.enabledTenant()) {
            return null;
        }
        return TenantContextHolder.getCurrentTenant();
    }

    public static SysTenantDTO getTenant(Long tenantId) {
        if (!TenantClient.enabledTenant()) {
            return null;
        }
        if (tenantId == null) {
            return null;
        }
        return (SysTenantDTO)TenantClient.getTenantProvider().getById(tenantId).get();
    }

    public static List<SysTenantDTO> getAllTenants() {
        if (!TenantClient.enabledTenant()) {
            return Collections.emptyList();
        }
        return new ArrayList<SysTenantDTO>(TenantClient.getTenantProvider().getAllTenant().values());
    }

    public static SysTenantDTO obtainTenantFromRequest() {
        if (!TenantClient.enabledTenant()) {
            return null;
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return TenantRequestUtil.obtainTenant(((ServletRequestAttributes)requestAttributes).getRequest());
    }

    private static TenantProvider getTenantProvider() {
        if (INITED.compareAndSet(false, true)) {
            tenantProvider = (TenantProvider)SpringContextHolder.getObjectProvider(TenantProvider.class).getIfAvailable();
        }
        return tenantProvider;
    }

    static {
        INITED = new AtomicBoolean(false);
    }
}

