/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.datasource;

import com.elitesland.cloudt.context.util.DatasourceLoadUtil;
import com.elitesland.cloudt.tenant.config.datasource.AbstractTenantDatasourceProvider;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="elitesland.tenant.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class TenantDataSourceListener
implements SmartApplicationListener,
InitializingBean {
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType.isAssignableFrom(ApplicationContextInitializedEvent.class);
    }

    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        if (event instanceof ApplicationContextInitializedEvent) {
            ConfigurableEnvironment env = ((ApplicationContextInitializedEvent)event).getApplicationContext().getEnvironment();
            DataSource dataSource = this.loadingDataSource((Environment)env);
            this.loadingDefaultSchema((Environment)env);
            this.loadingDatabase((Environment)env, dataSource);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)AbstractTenantDatasourceProvider.getDefaultSchema(), (String)"\u9ed8\u8ba4\u79df\u6237schema\u4e3a\u7a7a");
        Assert.notNull((Object)AbstractTenantDatasourceProvider.getDefaultDataSource(), (String)"\u9ed8\u8ba4\u6570\u636e\u6e90\u4e3a\u7a7a");
    }

    private Database loadingDatabase(Environment env, DataSource dataSource) {
        Database database = null;
        if (dataSource instanceof HikariDataSource && (database = AbstractTenantDatasourceProvider.getDatabaseTypeByUrl(((HikariDataSource)dataSource).getJdbcUrl())) != null) {
            AbstractTenantDatasourceProvider.setDatabaseType(database);
            return database;
        }
        String dbTypeStr = env.getProperty("spring.jpa.database");
        if (StringUtils.hasText((String)dbTypeStr)) {
            try {
                database = Database.valueOf((String)dbTypeStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            if (database != null) {
                AbstractTenantDatasourceProvider.setDatabaseType(database);
                return database;
            }
        }
        return database;
    }

    private String loadingDefaultSchema(Environment env) {
        String schema = env.getProperty("elitesland.tenant.client.default-schema");
        if (StringUtils.hasText((String)schema)) {
            AbstractTenantDatasourceProvider.setDefaultSchema(schema);
        }
        return schema;
    }

    private DataSource loadingDataSource(Environment env) {
        DataSource dataSource = DatasourceLoadUtil.loadForHikari((Environment)env);
        AbstractTenantDatasourceProvider.setDefaultDataSource(dataSource);
        return dataSource;
    }
}

