/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.support;

import com.elitesland.cloudt.context.base.AbstractEnvironmentPostProcessor;
import com.elitesland.cloudt.tenant.config.datasource.hibernate.HibernateTenantDatasourceProvider;
import com.elitesland.cloudt.tenant.config.datasource.hibernate.HibernateTenantIdentifierResolver;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.MultiTenancyStrategy;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.util.CollectionUtils;

public class TenantEnvironmentDefaultConfig
extends AbstractEnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        Map<String, Object> defaultProperties = this.createDefaultProperties(environment);
        if (!CollectionUtils.isEmpty(defaultProperties)) {
            TenantEnvironmentDefaultConfig.addOrReplace((MutablePropertySources)propertySources, defaultProperties);
        }
    }

    private Map<String, Object> createDefaultProperties(ConfigurableEnvironment environment) {
        HashMap<String, Object> defaultProperties = new HashMap<String, Object>(8);
        if (TenantEnvironmentDefaultConfig.enabledTenant((Environment)environment)) {
            defaultProperties.put("spring.jpa.properties.hibernate.multiTenancy", MultiTenancyStrategy.SCHEMA.name());
            defaultProperties.put("spring.jpa.properties.hibernate.tenant_identifier_resolver", HibernateTenantIdentifierResolver.class.getName());
            defaultProperties.put("spring.jpa.properties.hibernate.multi_tenant_connection_provider", HibernateTenantDatasourceProvider.class.getName());
        }
        defaultProperties.put("spring.jpa.hibernate.ddl-auto", "none");
        defaultProperties.put("spring.jpa.properties.hibernate.hbm2ddl.auto", "none");
        return defaultProperties;
    }

    private static boolean enabledTenant(Environment environment) {
        String enabled = environment.getProperty("elitesland.tenant.client.enabled");
        return enabled == null || "true".equalsIgnoreCase(enabled);
    }

    static class TenantEnabledListener
    implements SmartApplicationListener {
        TenantEnabledListener() {
        }

        public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
            return eventType.isAssignableFrom(ApplicationContextInitializedEvent.class);
        }

        public void onApplicationEvent(ApplicationEvent event) {
            ConfigurableEnvironment environment;
            if (event instanceof ApplicationContextInitializedEvent && !TenantEnvironmentDefaultConfig.enabledTenant((Environment)(environment = ((ApplicationContextInitializedEvent)event).getApplicationContext().getEnvironment()))) {
                TenantEnvironmentDefaultConfig.removeProperty((ConfigurableEnvironment)environment, (String[])new String[]{"spring.jpa.properties.hibernate.multiTenancy"});
                TenantEnvironmentDefaultConfig.removeProperty((ConfigurableEnvironment)environment, (String[])new String[]{"spring.jpa.properties.hibernate.tenant_identifier_resolver"});
                TenantEnvironmentDefaultConfig.removeProperty((ConfigurableEnvironment)environment, (String[])new String[]{"spring.jpa.properties.hibernate.multi_tenant_connection_provider"});
            }
        }
    }
}

