/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.support;

import com.elitesland.cloudt.tenant.config.TenantClientProperties;
import com.elitesland.cloudt.tenant.config.support.TenantContextHolder;
import com.elitesland.cloudt.tenant.util.TenantRequestUtil;
import com.elitesland.yst.core.common.CloudtInterceptor;
import com.elitesland.yst.system.dto.SysTenantDTO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;

public class TenantRequestInterceptor
implements CloudtInterceptor {
    private static final Logger log = LogManager.getLogger(TenantRequestInterceptor.class);
    private final TenantClientProperties clientProperties;

    public TenantRequestInterceptor(TenantClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        SysTenantDTO tenant = TenantRequestUtil.obtainTenant(request);
        if (tenant != null) {
            TenantContextHolder.setCurrentTenant(tenant);
        }
        return true;
    }

    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        TenantContextHolder.clearCurrentTenant();
    }
}

