/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.rpc.consumer;

import com.elitesland.cloudt.context.flyway.FlywayBuilder;
import com.elitesland.cloudt.context.flyway.support.FlywayHelper;
import com.elitesland.cloudt.tenant.TenantClient;
import com.elitesland.cloudt.tenant.config.datasource.AbstractTenantDatasourceProvider;
import com.elitesland.cloudt.tenant.rpc.consumer.TenantDatabaseRpcProvider;
import com.elitesland.yst.common.base.ApiResult;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class TenantDatabaseRpcProviderImpl
implements TenantDatabaseRpcProvider {
    private static final Logger log = LogManager.getLogger(TenantDatabaseRpcProviderImpl.class);
    @Autowired(required=false)
    private FlywayBuilder flywayBuilder;
    @Autowired(required=false)
    private FlywayHelper flywayHelper;

    @Override
    public ApiResult<Boolean> schemaCreate(String schema) {
        if (!TenantClient.enabledTenant()) {
            log.warn("\u672a\u542f\u7528\u79df\u6237\u529f\u80fd");
            return ApiResult.fail((String)"\u672a\u542f\u7528\u79df\u6237\u529f\u80fd");
        }
        log.info("\u521b\u5efa\u65b0\u79df\u6237schema\uff1a{}", (Object)schema);
        try {
            this.flywayHelper.migrate(() -> this.flywayBuilder.createFlywayForTenant(AbstractTenantDatasourceProvider.getDefaultSchema(), schema));
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u79df\u6237schema\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)e.getMessage());
        }
        log.info("\u521b\u5efa\u65b0\u79df\u6237schema\uff1a\u3010{}\u3011\u6210\u529f\uff01", (Object)schema);
        return ApiResult.ok((Object)true);
    }
}

