/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.support;

import com.elitesland.cloudt.tenant.config.TenantClientProperties;
import com.elitesland.cloudt.tenant.config.support.TenantContextHolder;
import com.elitesland.cloudt.tenant.util.TenantRequestUtil;
import com.elitesland.yst.core.common.CloudtInterceptor;
import com.elitesland.yst.system.dto.SysTenantDTO;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.CollectionUtils;

public class TenantRequestInterceptor
implements CloudtInterceptor {
    private static final Logger log = LogManager.getLogger(TenantRequestInterceptor.class);
    private final List<RequestMatcher> excludeRequestMatcher;

    public TenantRequestInterceptor(TenantClientProperties clientProperties) {
        this.excludeRequestMatcher = this.createExcludeRequestMatcher(clientProperties.getExcludePattern());
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        if (this.isExclude(request)) {
            return true;
        }
        SysTenantDTO tenant = TenantRequestUtil.obtainTenant(request);
        if (tenant != null) {
            TenantContextHolder.setCurrentTenant(tenant);
        }
        return true;
    }

    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        TenantContextHolder.clearCurrentTenant();
    }

    private boolean isExclude(HttpServletRequest request) {
        if (this.excludeRequestMatcher.isEmpty()) {
            return false;
        }
        return this.excludeRequestMatcher.stream().anyMatch(t -> t.matches(request));
    }

    private List<RequestMatcher> createExcludeRequestMatcher(Set<String> excludePath) {
        HashSet<String> paths = new HashSet<String>(CloudtInterceptor.staticResourcePatter());
        if (!CollectionUtils.isEmpty(excludePath)) {
            paths.addAll(excludePath);
        }
        return paths.stream().map(AntPathRequestMatcher::new).collect(Collectors.toList());
    }
}

