/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.support.redis;

import com.elitesland.cloudt.context.redis.CloudtRedisAutoConfiguration;
import com.elitesland.cloudt.context.redis.RedisKeyPrefix;
import com.elitesland.cloudt.context.redis.RedisWrapper;
import com.elitesland.cloudt.tenant.config.TenantClientProperties;
import com.elitesland.cloudt.tenant.config.support.TenantContextHolder;
import com.elitesland.cloudt.tenant.config.support.TenantSession;
import com.elitesland.cloudt.tenant.config.support.redis.TenantRedisWrapper;
import com.elitesland.yst.system.dto.SysTenantDTO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="elitesland.tenant.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={CloudtRedisAutoConfiguration.class})
public class TenantRedisAutoConfiguration {
    private static final Logger log = LogManager.getLogger(TenantRedisAutoConfiguration.class);

    @Bean(value={"tenantRedisWrapper"})
    @Primary
    public RedisWrapper tenantRedisWrapper() {
        log.info("\u521d\u59cb\u5316tenantRedisWrapper");
        return new TenantRedisWrapper();
    }

    @Bean
    public RedisKeyPrefix tenantRedisKeyPrefix(TenantClientProperties clientProperties) {
        return () -> {
            if (!clientProperties.isRedisSeparate()) {
                return "";
            }
            boolean useDefault = TenantSession.getUseDefault();
            if (useDefault) {
                return clientProperties.getDefaultRedisKeyPrefix();
            }
            SysTenantDTO tenant = TenantSession.getCurrentTenant();
            if (tenant == null) {
                tenant = TenantContextHolder.getCurrentTenant();
            }
            if (tenant == null) {
                return clientProperties.getDefaultRedisKeyPrefix();
            }
            return "tenant_" + tenant.getTenantCode();
        };
    }
}

