/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.filter;

import com.elitesland.cloudt.tenant.TenantClient;
import com.elitesland.cloudt.tenant.config.support.TenantContextHolder;
import com.elitesland.yst.system.dto.SysTenantDTO;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Activate(group={"provider", "consumer"})
public class DubboTenantContextFilter
implements Filter {
    private static final Logger log = LogManager.getLogger(DubboTenantContextFilter.class);
    private static final String ATTACHMENT_KEY_TENANT_ID = "cloudt_tenant_id";
    private static final ThreadLocal<Boolean> NOT_NEED_TENANT = new ThreadLocal();

    public static void setNotNeedTenant() {
        NOT_NEED_TENANT.set(true);
    }

    public static void removeNotNeedTenant() {
        NOT_NEED_TENANT.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RpcServiceContext rpcContext = RpcContext.getServiceContext();
        if (rpcContext.getUrl() == null || !TenantClient.enabledTenant()) {
            return invoker.invoke(invocation);
        }
        if (rpcContext.isProviderSide()) {
            SysTenantDTO tenantDTO = null;
            String tenantId = rpcContext.getAttachment(ATTACHMENT_KEY_TENANT_ID);
            if (tenantId != null && tenantId.length() > 0 && (tenantDTO = TenantClient.getTenant(Long.parseLong(tenantId))) != null) {
                this.setTenant(tenantDTO);
                log.info("\u5f53\u524d\u79df\u6237\uff1a{}", (Object)tenantDTO.getTenantCode());
            }
            try {
                Result result = invoker.invoke(invocation);
                return result;
            }
            finally {
                if (tenantDTO != null) {
                    this.clearTenant();
                }
            }
        }
        Boolean isNotNeedTenant = NOT_NEED_TENANT.get();
        if (!Boolean.TRUE.equals(isNotNeedTenant)) {
            SysTenantDTO tenantDTO = TenantClient.getSessionTenant();
            if (tenantDTO != null) {
                rpcContext.setAttachment(ATTACHMENT_KEY_TENANT_ID, tenantDTO.getId().toString());
            }
            NOT_NEED_TENANT.remove();
        }
        return invoker.invoke(invocation);
    }

    private void setTenant(SysTenantDTO tenant) {
        TenantContextHolder.setCurrentTenant(tenant);
    }

    private void clearTenant() {
        TenantContextHolder.clearCurrentTenant();
    }
}

