/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.provider;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.cloudt.context.redis.RedisWrapper;
import com.elitesland.cloudt.tenant.filter.DubboTenantContextFilter;
import com.elitesland.cloudt.tenant.rpc.TenantRpcProvider;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.common.CloudtOptional;
import com.elitesland.yst.common.util.RedisUtils;
import com.elitesland.yst.system.dto.SysTenantDTO;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Assert;

public class TenantProvider {
    private static final Logger log = LogManager.getLogger(TenantProvider.class);
    private final TenantRpcProvider tenantRpcProvider;
    private final RedisUtils redisUtils;
    private final RedisWrapper redisWrapper;
    private final Cache<String, SysTenantDTO> tenantCache;

    public TenantProvider(TenantRpcProvider tenantRpcProvider, RedisUtils redisUtils, RedisWrapper redisWrapper) {
        this.tenantRpcProvider = tenantRpcProvider;
        this.redisUtils = redisUtils;
        this.redisWrapper = redisWrapper;
        this.tenantCache = Caffeine.newBuilder().maximumSize(400L).expireAfterWrite(Duration.ofHours(2L)).build();
    }

    public Map<String, SysTenantDTO> getAllTenant() {
        List<SysTenantDTO> tenants = this.queryAllTenants();
        if (tenants.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, SysTenantDTO> tenantMap = tenants.stream().collect(Collectors.toMap(t -> t.getId().toString(), t -> t, (t1, t2) -> t1));
        return Collections.unmodifiableMap(tenantMap);
    }

    public CloudtOptional<SysTenantDTO> getById(Long id) {
        Assert.notNull((Object)id, (String)"\u79df\u6237ID\u4e3a\u7a7a");
        SysTenantDTO tenant = (SysTenantDTO)this.tenantCache.getIfPresent((Object)id.toString());
        if (tenant != null) {
            return CloudtOptional.of((Serializable)tenant);
        }
        List<SysTenantDTO> tenants = this.queryAllTenants();
        if (tenants.isEmpty()) {
            return CloudtOptional.empty();
        }
        tenant = tenants.stream().filter(t -> t.getId().equals(id)).findAny().orElse(null);
        if (tenant != null) {
            this.tenantCache.put((Object)id.toString(), (Object)tenant);
        }
        return CloudtOptional.of((Serializable)tenant);
    }

    public CloudtOptional<SysTenantDTO> getByDomain(String domain) {
        SysTenantDTO tenant = (SysTenantDTO)this.tenantCache.getIfPresent((Object)domain);
        if (tenant != null) {
            return CloudtOptional.of((Serializable)tenant);
        }
        List<SysTenantDTO> tenants = this.queryAllTenants();
        if (tenants.isEmpty()) {
            return CloudtOptional.empty();
        }
        tenant = tenants.stream().filter(t -> CharSequenceUtil.equals((CharSequence)t.getCustomDomain(), (CharSequence)domain) || CharSequenceUtil.equals((CharSequence)t.getTenantDomain(), (CharSequence)domain)).findAny().orElse(null);
        if (tenant != null) {
            this.tenantCache.put((Object)domain, (Object)tenant);
        }
        return CloudtOptional.of((Serializable)tenant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SysTenantDTO> queryAllTenants() {
        String cacheKey = "yst_tenant:all";
        Map redisAll = null;
        try {
            redisAll = (Map)this.redisWrapper.apply(() -> this.redisUtils.get(cacheKey), null);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u79df\u6237\u7f13\u5b58\u5931\u8d25\uff1a", (Throwable)e);
        }
        if (redisAll != null) {
            return new ArrayList<SysTenantDTO>(redisAll.values());
        }
        ApiResult<List<SysTenantDTO>> queryTenantResult = null;
        DubboTenantContextFilter.setNotNeedTenant();
        try {
            queryTenantResult = this.tenantRpcProvider.allTenants();
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            List<SysTenantDTO> list = Collections.emptyList();
            return list;
        }
        finally {
            DubboTenantContextFilter.removeNotNeedTenant();
        }
        if (!queryTenantResult.isSuccess() || queryTenantResult.getData() == null) {
            log.error("\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)(queryTenantResult.getMsg() + "\uff1b" + queryTenantResult.getErrorMsg()));
            return Collections.emptyList();
        }
        if (((List)queryTenantResult.getData()).isEmpty()) {
            log.warn("\u672a\u67e5\u8be2\u5230\u6709\u6548\u79df\u6237\u4fe1\u606f");
        }
        Map<String, SysTenantDTO> tenantMap = ((List)queryTenantResult.getData()).stream().collect(Collectors.toMap(t -> t.getId().toString(), t -> t, (t1, t2) -> t1));
        try {
            this.redisWrapper.apply(() -> {
                this.redisUtils.set(cacheKey, (Object)tenantMap);
                return null;
            }, null);
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u79df\u6237\u7f13\u5b58\u5931\u8d25\uff1a", (Throwable)e);
        }
        return new ArrayList<SysTenantDTO>(tenantMap.values());
    }
}

