/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.util.export.database.mysql;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.ColumnIndexInfo;
import cn.hutool.db.meta.IndexInfo;
import cn.hutool.db.meta.Table;
import com.elitesland.cloudt.tenant.util.export.DataBaseExport;
import com.elitesland.cloudt.tenant.util.export.database.AbstractExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MySqlExporter
extends AbstractExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlExporter.class);

    public MySqlExporter(DataBaseExport dataBaseExport) {
        super(dataBaseExport);
    }

    @Override
    protected void beforeExport() {
    }

    @Override
    protected String generateTableDdl(Table table) {
        StringBuilder result = new StringBuilder();
        result.append(this.generateTable(table));
        result.append(" ( \n");
        String columns = this.generateColumns(table);
        result.append(columns);
        String keys = this.generateKeys(table);
        result.append((String)(StringUtils.hasText((String)keys) ? ", \n" + keys + "\n" : "\n"));
        result.append(String.format(") COMMENT = '%s'; ", CharSequenceUtil.blankToDefault((CharSequence)table.getComment(), (String)table.getTableName())));
        return result.toString();
    }

    private String generateTable(Table table) {
        String tableName = this.sensitiveName(table.getTableName(), this.dataBaseExport.isTableNameSensitive());
        switch (this.dataBaseExport.getTableCreate()) {
            case CREATE: {
                return String.format("CREATE TABLE %s ", tableName);
            }
            case DROP_BEFORE_CREATE: {
                return String.format("DROP TABLE IF EXISTS %s;%nCREATE TABLE %s ", tableName, tableName);
            }
            case CREATE_IF_NO_EXISTS: {
                return String.format("CREATE TABLE IF NOT EXISTS %s ", tableName);
            }
        }
        throw new RuntimeException("\u672a\u77e5\u521b\u5efa\u7b56\u7565");
    }

    private String sensitiveName(String name, boolean sensitive) {
        return sensitive ? name : "`" + name + "`";
    }

    private String generateColumns(Table table) {
        ArrayList<String> ddlList = new ArrayList<String>();
        for (Column column : table.getColumns()) {
            StringBuilder result = new StringBuilder();
            result.append(String.format("%s    ", this.sensitiveName(column.getName(), this.dataBaseExport.isColumnNameSensitive())));
            result.append(this.normalizeColumnType(column));
            result.append(this.normalizeNullable(column));
            if (column.isAutoIncrement()) {
                result.append("AUTO_INCREMENT ");
            }
            result.append(String.format("COMMENT '%s'", this.normalizeComment(CharSequenceUtil.blankToDefault((CharSequence)column.getComment(), (String)column.getName()))));
            ddlList.add(result.toString());
        }
        return String.join((CharSequence)", \n", ddlList);
    }

    private String normalizeColumnType(Column column) {
        Set<Integer> noSizeTypes = Set.of(91, 92, 93, 2013, 2014, -4, 2004, 2005, 2011, -1, 8);
        String typeName = column.getTypeName().toLowerCase();
        if (noSizeTypes.contains(column.getType())) {
            return String.format("%s    ", typeName);
        }
        if (typeName.contains("unsigned")) {
            return String.format("%s(%s) unsigned    ", typeName.split(" ")[0], column.getSize());
        }
        return String.format("%s(%s)    ", column.getTypeName().toLowerCase(), column.getSize());
    }

    private String normalizeNullable(Column column) {
        if (column.isNullable()) {
            Set<Integer> originalTypeValue = Set.of(Integer.valueOf(93), Integer.valueOf(91), Integer.valueOf(92), Integer.valueOf(2013), Integer.valueOf(2014));
            if (StringUtils.hasText((String)column.getColumnDef())) {
                if (originalTypeValue.contains(column.getType())) {
                    return String.format("DEFAULT %s ", column.getColumnDef());
                }
                return String.format("DEFAULT '%s' ", column.getColumnDef());
            }
            if (column.getType() == 93) {
                return "NULL DEFAULT NULL ";
            }
            return "DEFAULT NULL ";
        }
        return "NOT NULL ";
    }

    private String normalizeComment(String comment) {
        if (!StringUtils.hasText((String)comment)) {
            return null;
        }
        while (comment.startsWith("'")) {
            comment = comment.substring(1);
        }
        while (comment.endsWith("'")) {
            comment = comment.substring(0, comment.length() - 1);
        }
        return comment;
    }

    private String generateKeys(Table table) {
        List indexInfoList = table.getIndexInfoList();
        if (CollectionUtils.isEmpty((Collection)indexInfoList)) {
            return null;
        }
        ArrayList<Object> ddlList = new ArrayList<Object>();
        for (IndexInfo indexInfo : indexInfoList) {
            if (indexInfo.getIndexName().equals("PRIMARY")) {
                ddlList.add(String.format("PRIMARY KEY (%s)", this.generateKeyColumns(indexInfo.getColumnIndexInfoList())));
                continue;
            }
            ddlList.add((indexInfo.isNonUnique() ? "KEY " : "UNIQUE KEY ") + String.format("`%s` (%s)", indexInfo.getIndexName(), this.generateKeyColumns(indexInfo.getColumnIndexInfoList())));
        }
        return String.join((CharSequence)", \n", ddlList);
    }

    private String generateKeyColumns(List<ColumnIndexInfo> indexInfoList) {
        return indexInfoList.stream().map(t -> String.format("`%s`", t.getColumnName())).collect(Collectors.joining(", "));
    }
}

