/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.support.cloudstream;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cloudt.tenant.TenantClient;
import com.elitesland.cloudt.tenant.config.support.TenantContextHolder;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.dto.SysTenantDTO;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;

public class TenantMessagingInputInterceptor
implements ChannelInterceptor {
    private static final Logger log = LogManager.getLogger(TenantMessagingInputInterceptor.class);

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        Long tenantId = this.obtainTenantId(message);
        if (tenantId != null) {
            SysTenantDTO tenant = TenantClient.getTenant(tenantId);
            if (tenant == null) {
                throw new BusinessException("MQ\u6d88\u606f\u3010" + this.obtainMessageId(message) + "\u3011\u5904\u7406\u5931\u8d25\uff0c\u672a\u627e\u5230\u79df\u6237\uff1a" + tenantId);
            }
            TenantContextHolder.setCurrentTenant(tenant);
        }
        return message;
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        Long tenantId = this.obtainTenantId(message);
        if (tenantId != null) {
            TenantContextHolder.clearCurrentTenant();
        }
        if (ex == null) {
            log.info("MQ\u6d88\u606f\u3010{}\u3011\u63a5\u6536\u5904\u7406\u6210\u529f\uff0c\u6240\u5c5e\u79df\u6237{}", new Supplier[]{() -> this.obtainMessageId(message), () -> tenantId});
            return;
        }
        log.error("MQ\u6d88\u606f\u3010" + this.obtainMessageId(message) + "\u3011\u63a5\u6536\u5904\u7406\u5931\u8d25\uff0c\u6240\u5c5e\u79df\u6237" + this.obtainMessageId(message), (Throwable)ex);
    }

    private String obtainMessageId(Message<?> message) {
        return ((Serializable)ObjectUtil.defaultIfNull((Object)message.getHeaders().getId(), (Object)"")).toString();
    }

    private Long obtainTenantId(Message<?> message) {
        Object tenantId = message.getHeaders().get((Object)"current_tenant_id");
        if (tenantId == null) {
            return null;
        }
        return tenantId instanceof Long ? (Long)tenantId : Long.parseLong(tenantId.toString());
    }
}

