/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.rpc.consumer;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.cloudt.context.flyway.FlywayBuilder;
import com.elitesland.cloudt.context.flyway.support.FlywayHelper;
import com.elitesland.cloudt.context.util.database.SqlUtil;
import com.elitesland.cloudt.tenant.TenantClient;
import com.elitesland.cloudt.tenant.config.TenantClientProperties;
import com.elitesland.cloudt.tenant.config.datasource.AbstractTenantDatasourceProvider;
import com.elitesland.cloudt.tenant.rpc.consumer.TenantDatabaseRpcProvider;
import com.elitesland.yst.common.base.ApiResult;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.vendor.Database;

@DubboService
public class TenantDatabaseRpcProviderImpl
implements TenantDatabaseRpcProvider {
    private static final Logger log = LogManager.getLogger(TenantDatabaseRpcProviderImpl.class);
    @Autowired(required=false)
    private FlywayBuilder flywayBuilder;
    @Autowired(required=false)
    private FlywayHelper flywayHelper;
    @Autowired(required=false)
    private TenantClientProperties tenantClientProperties;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public ApiResult<Boolean> schemaCreate(String schema) {
        if (!TenantClient.enabledTenant()) {
            log.warn("\u672a\u542f\u7528\u79df\u6237\u529f\u80fd");
            return ApiResult.fail((String)"\u672a\u542f\u7528\u79df\u6237\u529f\u80fd");
        }
        if (!this.tenantClientProperties.isDatabaseSeparate()) {
            log.warn("\u672a\u542f\u7528\u6570\u636e\u9694\u79bb");
            return ApiResult.ok((Object)true);
        }
        log.info("\u521b\u5efa\u65b0\u79df\u6237schema\uff1a{}", (Object)schema);
        try {
            this.flywayHelper.migrate(() -> this.flywayBuilder.createFlywayForTenant(AbstractTenantDatasourceProvider.getDefaultSchema(), schema));
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u79df\u6237schema\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)e.getMessage());
        }
        log.info("\u521b\u5efa\u65b0\u79df\u6237schema\uff1a\u3010{}\u3011\u6210\u529f\uff01", (Object)schema);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<Boolean> schemaDrop(String schema) {
        log.info("\u5220\u9664\u79df\u6237schema\uff1a{}", (Object)schema);
        Database database = AbstractTenantDatasourceProvider.getDatabaseType();
        if (database == null) {
            return ApiResult.fail((String)"\u672a\u77e5\u6570\u636e\u5e93\u7c7b\u578b");
        }
        boolean result = this.dropSchema(database, this.normalizeSchemaName(schema));
        return ApiResult.ok((Object)result);
    }

    private String normalizeSchemaName(String schema) {
        Object prefix = AbstractTenantDatasourceProvider.getDefaultSchema();
        prefix = CharSequenceUtil.isBlank((CharSequence)prefix) ? "" : (String)prefix + "_";
        return (String)prefix + schema;
    }

    private boolean dropSchema(Database database, String schema) {
        try {
            boolean exists;
            String sql = SqlUtil.generateExistsSchemaSql((Database)database, (String)schema);
            boolean bl = exists = !this.jdbcTemplate.queryForList(sql).isEmpty();
            if (!exists) {
                log.info("\u5220\u9664schema\u5931\u8d25\uff0cschema \u3010{}\u3011\u4e0d\u5b58\u5728", (Object)schema);
                return true;
            }
            sql = SqlUtil.generateDropSchemaSql((Database)database, (String)schema);
            int result = this.jdbcTemplate.update(sql);
            log.info("\u5220\u9664schema\u3010{}\u3011\u7ed3\u679c\uff1a{}", (Object)schema, (Object)result);
            return true;
        }
        catch (Exception e) {
            log.error("\u5220\u9664schema\u5931\u8d25\uff1a", (Throwable)e);
            return false;
        }
    }
}

