/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.util.export;

import com.elitesland.cloudt.tenant.util.export.database.TableCreate;
import com.elitesland.cloudt.tenant.util.export.database.mysql.MySqlExporter;
import com.elitesland.cloudt.tenant.util.export.database.oracle.OracleExporter;
import java.util.function.Consumer;
import org.springframework.util.Assert;

public class DataBaseExport {
    private String jdbcUrl;
    private String driverClassName;
    private String username;
    private String password;
    private String[] tables;
    private TableCreate tableCreate = TableCreate.CREATE;
    private boolean tableNameSensitive = false;
    private boolean columnNameSensitive = false;

    private DataBaseExport() {
    }

    public static DataBaseExport builder() {
        return new DataBaseExport();
    }

    public void exportToMysql(Consumer<String> tableDdlConsumer) {
        new MySqlExporter(this).export(tableDdlConsumer);
    }

    public void exportToOracle(Consumer<String> tableDdlConsumer) {
        new OracleExporter(this).export(tableDdlConsumer);
    }

    public DataBaseExport setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public DataBaseExport setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        return this;
    }

    public DataBaseExport setUsername(String username) {
        this.username = username;
        return this;
    }

    public DataBaseExport setPassword(String password) {
        this.password = password;
        return this;
    }

    public DataBaseExport setTables(String ... tables) {
        this.tables = tables;
        return this;
    }

    public DataBaseExport setTableCreate(TableCreate tableCreate) {
        Assert.notNull((Object)((Object)tableCreate), (String)"tableCreate\u4e0d\u80fd\u4e3a\u7a7a");
        this.tableCreate = tableCreate;
        return this;
    }

    public DataBaseExport setTableNameSensitive(boolean tableNameSensitive) {
        this.tableNameSensitive = tableNameSensitive;
        return this;
    }

    public DataBaseExport setColumnNameSensitive(boolean columnNameSensitive) {
        this.columnNameSensitive = columnNameSensitive;
        return this;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String[] getTables() {
        return this.tables;
    }

    public TableCreate getTableCreate() {
        return this.tableCreate;
    }

    public boolean isTableNameSensitive() {
        return this.tableNameSensitive;
    }

    public boolean isColumnNameSensitive() {
        return this.columnNameSensitive;
    }
}

