/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.support.cloudstream;

import com.elitesland.cloudt.tenant.TenantClient;
import com.elitesland.yst.system.dto.SysTenantDTO;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;

public class TenantMessagingOutputInterceptor
implements ChannelInterceptor {
    private static final Logger log = LogManager.getLogger(TenantMessagingOutputInterceptor.class);

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        SysTenantDTO tenant = TenantClient.getSessionTenant();
        if (tenant == null) {
            return message;
        }
        MessageHeaderAccessor headerAccessor = MessageHeaderAccessor.getMutableAccessor(message);
        headerAccessor.setHeaderIfAbsent("current_tenant_id", (Object)tenant.getId());
        return MessageBuilder.withPayload((Object)message.getPayload()).copyHeaders((Map)headerAccessor.getMessageHeaders()).build();
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        if (ex == null) {
            log.info("MQ\u6d88\u606f\u3010{}\u3011\u53d1\u9001\u6210\u529f\uff0c\u6240\u5c5e\u79df\u6237{}\uff01", new Supplier[]{() -> message.getHeaders().getId(), () -> message.getHeaders().get((Object)"current_tenant_id")});
            return;
        }
        log.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a", (Throwable)ex);
    }
}

