/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.cloudt.context.flyway.FlywayBuilder;
import com.elitesland.cloudt.context.flyway.FlywayCloudtAutoConfiguration;
import com.elitesland.cloudt.context.flyway.support.FlywayHelper;
import com.elitesland.cloudt.context.redis.RedisWrapper;
import com.elitesland.cloudt.tenant.TenantClient;
import com.elitesland.cloudt.tenant.config.TenantClientProperties;
import com.elitesland.cloudt.tenant.config.support.TenantContextTransfer;
import com.elitesland.cloudt.tenant.config.support.TenantRequestInterceptor;
import com.elitesland.cloudt.tenant.config.support.cloudstream.SpringCloudStreamConfig;
import com.elitesland.cloudt.tenant.initializer.TenantSchemaInitializer;
import com.elitesland.cloudt.tenant.provider.ClientSyncTenantProvider;
import com.elitesland.cloudt.tenant.provider.TenantIsolate;
import com.elitesland.cloudt.tenant.provider.TenantProvider;
import com.elitesland.cloudt.tenant.rpc.TenantRpcProvider;
import com.elitesland.cloudt.tenant.util.TenantRequestUtil;
import com.elitesland.yst.common.util.RedisUtils;
import com.elitesland.yst.core.isolate.Isolatable;
import com.elitesland.yst.core.provider.tenant.TenantClientProvider;
import com.elitesland.yst.system.dto.SysTenantDTO;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.task.TaskExecutor;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="elitesland.tenant.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={TenantClientProperties.class})
@Import(value={SpringCloudStreamConfig.class})
@AutoConfigureAfter(value={FlywayCloudtAutoConfiguration.class})
public class CloudtTenantClientAutoConfiguration {
    private static final Logger log = LogManager.getLogger(CloudtTenantClientAutoConfiguration.class);
    private final TenantClientProperties clientProperties;
    @DubboReference
    private TenantRpcProvider tenantRpcProvider;

    public CloudtTenantClientAutoConfiguration(TenantClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    @Bean
    public TenantProvider tenantProvider(RedisUtils redisUtils, RedisWrapper redisWrapper) {
        return new TenantProvider(this.tenantRpcProvider, redisUtils, redisWrapper);
    }

    @Bean
    public ClientSyncTenantProvider clientSyncTenantProvider(TenantProvider tenantProvider, FlywayHelper flywayHelper, FlywayBuilder flywayBuilder) {
        return new ClientSyncTenantProvider(this.clientProperties, tenantProvider, flywayHelper, flywayBuilder);
    }

    @Bean
    public TenantSchemaInitializer tenantSchemaInitializer(ClientSyncTenantProvider clientSyncTenantProvider, TaskExecutor taskExecutor) {
        return new TenantSchemaInitializer(clientSyncTenantProvider, taskExecutor, this.clientProperties);
    }

    @Bean
    public TenantRequestInterceptor tenantRequestInterceptor() {
        return new TenantRequestInterceptor(this.clientProperties);
    }

    @Bean
    public TenantContextTransfer tenantContextTransfer() {
        return new TenantContextTransfer();
    }

    @Bean
    @Primary
    public TenantClientProvider tenantClientProvider() {
        return new TenantClientProvider(){

            public boolean enabledTenant() {
                return true;
            }

            public SysTenantDTO getCurrentTenant() {
                return TenantClient.getCurrentTenant();
            }

            public SysTenantDTO getSessionTenant() {
                return TenantClient.getSessionTenant();
            }

            public SysTenantDTO getTenant(Long sysTenantId) {
                return TenantClient.getTenant(sysTenantId);
            }

            public List<SysTenantDTO> getAllTenants() {
                return TenantClient.getAllTenants();
            }

            public SysTenantDTO obtainTenantFromRequest() {
                return TenantClient.obtainTenantFromRequest();
            }

            public boolean isDefaultDomainRequest() {
                RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
                if (requestAttributes == null) {
                    return false;
                }
                String domain = TenantRequestUtil.obtainTenantDomain(((ServletRequestAttributes)requestAttributes).getRequest());
                return CharSequenceUtil.equals((CharSequence)domain, (CharSequence)CloudtTenantClientAutoConfiguration.this.clientProperties.getTenantDomain());
            }
        };
    }

    @Bean
    @Primary
    public Isolatable tenantIsolate() {
        return new TenantIsolate();
    }
}

