/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.tenant.config.support.transaction;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.cloudt.context.transaction.TransactionWrapper;
import com.elitesland.cloudt.tenant.config.support.AbstractTenantIsolateDelegate;
import com.elitesland.yst.common.constant.TenantType;
import com.elitesland.yst.system.dto.SysTenantDTO;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TenantTransactionWrapper
extends AbstractTenantIsolateDelegate<Object, Object, TransactionStatus>
implements TransactionWrapper<Object, Object> {
    private static final Logger log = LogManager.getLogger(TenantTransactionWrapper.class);
    private static final String TRANSACTION_NAME_PREFIX = "cloudt_tenant";
    private final PlatformTransactionManager transactionManager;

    public TenantTransactionWrapper(PlatformTransactionManager platformTransactionManager) {
        this.transactionManager = platformTransactionManager;
    }

    public String transactionName() {
        return TRANSACTION_NAME_PREFIX;
    }

    @Override
    protected boolean supportApply(SysTenantDTO tenant) {
        String currentTransactionName = TransactionSynchronizationManager.getCurrentTransactionName();
        String newTransactionName = this.generateTransactionName(tenant);
        return !CharSequenceUtil.equals((CharSequence)newTransactionName, (CharSequence)currentTransactionName);
    }

    @Override
    protected TransactionStatus beforeApply(Callable<Object> runnable, SysTenantDTO tenant) {
        String newTransactionName = this.generateTransactionName(tenant);
        return this.buildTenantTransactionDefinition(newTransactionName);
    }

    @Override
    protected void afterCompletion(Object result, TransactionStatus transactionStatus, boolean useDefault, Exception exp) {
        if (exp == null) {
            this.transactionManager.commit(transactionStatus);
            return;
        }
        this.transactionManager.rollback(transactionStatus);
        log.error("\u6267\u884c\u4e1a\u52a1\u5f02\u5e38\uff1a", (Throwable)exp);
    }

    private TransactionStatus buildTenantTransactionDefinition(String newTransactionName) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(3);
        definition.setName(newTransactionName);
        return this.transactionManager.getTransaction((TransactionDefinition)definition);
    }

    private String generateTransactionName(SysTenantDTO tenant) {
        return TRANSACTION_NAME_PREFIX + (String)(tenant == null || tenant.getType() == TenantType.OPERATION ? "[default]" : "[" + tenant.getId() + "]");
    }
}

