package com.elitesland.yst.demo.provider;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.demo.dto.YstDemoDTO;
import com.elitesland.yst.demo.param.YstDemoDtoParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 示例数据服务接口.
 *
 * @author ryan.xu
 * @date 2022-02-15
 */
public interface YstDemoProvider {

    /**
     * 根据编码获取数据
     *
     * @param code 编码
     * @return 数据信息
     */
    ApiResult<YstDemoDTO> getByCode(@NotBlank(message = "编码不能为空") String code);

    /**
     * 查询数据
     *
     * @param reqDTO 查询参数
     * @return 数据信息
     */
    ApiResult<List<YstDemoDTO>> query(YstDemoDtoParam reqDTO);
}
