package com.elitesland.yst;

import com.elitesland.yst.common.util.SpringContextHolder;
import com.elitesland.yst.core.logInfo.ApplicationStartedEventListener;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * DEMO系统启动类.
 *
 * @author ryan.xu
 * @date 2022-02-15
 */
@SpringBootApplication(scanBasePackages = "com.elitesland.yst")
@EnableTransactionManagement
@EnableCaching
public class YstDemoApplication {

    public static void main(String[] args) {
        new SpringApplicationBuilder(YstDemoApplication.class)
                .listeners(new ApplicationStartedEventListener())
                .run(args);
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }
}
