package com.elitesland.yst.demo.controller;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.demo.service.YstDemoService;
import com.elitesland.yst.demo.vo.param.YstDemoQueryParamVO;
import com.elitesland.yst.demo.vo.resp.YstDemoRespVO;
import com.elitesland.yst.demo.vo.save.YstDemoSaveVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: ryan.xu
 * @since 2022/2/15
 */
@RestController
@RequestMapping("/demo")
@Api(value = "DEMO项目", tags = {"demo项目"})
@RequiredArgsConstructor
public class YstDemoController {

    private final YstDemoService ystDemoService;

    /**
     * @param id
     * @return
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("通过主键查询单条数据")
    ApiResult<YstDemoRespVO> findIdOne(@PathVariable Long id) {
        return ystDemoService.findById(id).map(ApiResult::ok)
                .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }

    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<YstDemoRespVO>> search(@RequestBody YstDemoQueryParamVO param) {
        val ret = ystDemoService.search(param);
        return ApiResult.ok(ret);
    }

    /**
     * 修改数据
     *
     * @param param 修改对象
     * @return 修改数据详情
     */
    @PutMapping("/update")
    @ApiOperation("修改数据")
    public ApiResult<Object> update(@RequestBody YstDemoSaveVO param) {
        ystDemoService.updateYstDemo(param);
        return ApiResult.ok();
    }

    /**
     * 新增数据
     *
     * @param param 新增数据
     * @return 新增数据情况
     */
    @PostMapping("/createOne")
    @ApiOperation("新增数据")
    public ApiResult<Object> createOne(@RequestBody YstDemoSaveVO param) {
        return ApiResult.ok(ystDemoService.saveYstDemo(param));
    }

}
