package com.elitesland.yst.demo.convert;


import com.elitesland.yst.demo.config.CustomMapperConfig;
import com.elitesland.yst.demo.entity.YstDemoDO;
import com.elitesland.yst.demo.vo.resp.YstDemoRespVO;
import com.elitesland.yst.demo.vo.save.YstDemoSaveVO;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

/**
 * @author ryan.xu
 * @date 2022-02-15
 */
@Mapper(config = CustomMapperConfig.class)
public interface YstDemoConvert {

    YstDemoConvert INSTANCE = Mappers.getMapper(YstDemoConvert.class);

    /***
     * 保存参数转换为DO
     * @param param
     * @return
     */
    YstDemoDO saveToDo(YstDemoSaveVO param);

    /**
     * do To Vo
     *
     * @param demoDO
     * @return
     */
    YstDemoRespVO doToVO(YstDemoDO demoDO);


    /**
     * 将 save param 更新到 do
     *
     * @param saveVO    保存参数
     * @param ystDemoDO do
     */
    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void updateDoFromSaveParam(YstDemoSaveVO saveVO, @MappingTarget YstDemoDO ystDemoDO);
}
