package com.elitesland.yst.demo.entity;

import com.elitesland.yst.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * demo.
 *
 * @author ryan.xu
 * @date 2022-02-15
 */
@Entity
@Table(name = "yst_demo", indexes = {
        @Index(name = "idx_yst_demo_code", columnList = "code_", unique = true)
})
@org.hibernate.annotations.Table(appliesTo = "yst_demo", comment = "示例")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class YstDemoDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -3564024897464522152L;

    @Column(name = "code_", columnDefinition = "varchar(128) not null  comment '编码'", nullable = false)
    private String code;

    @Column(name = "name", columnDefinition = "varchar(256) default null comment '名称'")
    private String name;

    @Column(name = "enabled", columnDefinition = "tinyint(1) default 0 comment '是否启用'", nullable = false)
    private Boolean enabled;

    @Column(name = "sort_no", columnDefinition = "int(10) default 1 comment '顺序号'", nullable = false)
    private Integer sortNo;

    @Column(name = "price", columnDefinition = "decimal(20,4) default 0 comment '价格'")
    private BigDecimal price;

    @Column(name = "pic_code", columnDefinition = "varchar(256) default null comment '图片编码'")
    private String picCode;

}
